/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commands.write.BackupPutMapRpcCommand;
import org.infinispan.commands.write.BackupWriteRpcCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commands.write.PrimaryAckCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.LockAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.remoting.inboundhandler.action.TriangleOrderAction;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TrianglePerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler
implements LockListener,
Action {
    private static final Log log = LogFactory.getLog(TrianglePerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private LockManager lockManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private long lockTimeout;
    private TriangleOrderManager triangleOrderManager;
    private RpcManager rpcManager;
    private CommandAckCollector commandAckCollector;
    private CommandsFactory commandsFactory;
    private Address localAddress;
    private boolean indirectRpc;

    @Inject
    public void inject(LockManager lockManager, ClusteringDependentLogic clusteringDependentLogic, Configuration configuration, TriangleOrderManager anotherTriangleOrderManager, RpcManager rpcManager, CommandAckCollector commandAckCollector, CommandsFactory commandsFactory) {
        this.lockManager = lockManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.lockTimeout = configuration.locking().lockAcquisitionTimeout();
        this.triangleOrderManager = anotherTriangleOrderManager;
        this.rpcManager = rpcManager;
        this.commandAckCollector = commandAckCollector;
        this.commandsFactory = commandsFactory;
        this.indirectRpc = configuration.clustering().biasAcquisition() != BiasAcquisition.NEVER;
    }

    @Start
    public void start() {
        this.localAddress = this.rpcManager.getAddress();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (order == DeliverOrder.TOTAL) {
            this.unexpectedDeliverMode(command, order);
        }
        try {
            switch (command.getCommandId()) {
                case 1: {
                    this.handleSingleRpcCommand((SingleRpcCommand)command, reply, order);
                    return;
                }
                case 61: {
                    this.handleBackupWriteRpcCommand((BackupWriteRpcCommand)command);
                    return;
                }
                case 66: {
                    this.handleBackupPutMapRpcCommand((BackupPutMapRpcCommand)command);
                    return;
                }
                case 2: {
                    this.handleBackupAckCommand((BackupAckCommand)command);
                    return;
                }
                case 41: {
                    this.handleBackupMultiKeyAckCommand((BackupMultiKeyAckCommand)command);
                    return;
                }
                case 42: {
                    this.handleExceptionAck((ExceptionAckCommand)command);
                    return;
                }
                case 73: {
                    this.handlePrimaryAck((PrimaryAckCommand)command);
                    return;
                }
                case 15: {
                    this.handleStateRequestCommand((StateRequestCommand)command, reply, order);
                    return;
                }
            }
            this.handleDefaultCommand(command, reply, order);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    public void onEvent(LockState state) {
        this.remoteCommandsExecutor.checkForReadyTasks();
    }

    @Override
    public ActionStatus check(ActionState state) {
        return this.isCommandSentBeforeFirstTopology(state.getCommandTopologyId()) ? ActionStatus.CANCELED : ActionStatus.READY;
    }

    public TriangleOrderManager getTriangleOrderManager() {
        return this.triangleOrderManager;
    }

    public BlockingTaskAwareExecutorService getRemoteExecutor() {
        return this.remoteCommandsExecutor;
    }

    public ClusteringDependentLogic getClusteringDependentLogic() {
        return this.clusteringDependentLogic;
    }

    @Override
    public void onFinally(ActionState state) {
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private void handleStateRequestCommand(StateRequestCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TOPOLOGY, order.preserveOrder());
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TOPOLOGY, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleDefaultCommand(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TX_DATA, order.preserveOrder());
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TX_DATA, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleBackupPutMapRpcCommand(BackupPutMapRpcCommand command) {
        int topologyId = command.getTopologyId();
        ReadyAction readyAction = this.createTriangleOrderAction(command, topologyId, command.getSequence(), command.getMap().keySet().iterator().next());
        BlockingRunnable runnable = this.createBackupPutMapRunnable(command, topologyId, readyAction);
        this.remoteCommandsExecutor.execute(runnable);
    }

    private void handleBackupWriteRpcCommand(BackupWriteRpcCommand command) {
        int topologyId = command.getTopologyId();
        ReadyAction readyAction = this.createTriangleOrderAction(command, topologyId, command.getSequence(), command.getKey());
        BlockingRunnable runnable = this.createBackupWriteRpcRunnable(command, topologyId, readyAction);
        this.remoteCommandsExecutor.execute(runnable);
    }

    private void handleExceptionAck(ExceptionAckCommand command) {
        command.ack();
    }

    private void handleBackupMultiKeyAckCommand(BackupMultiKeyAckCommand command) {
        command.ack();
    }

    private void handleBackupAckCommand(BackupAckCommand command) {
        command.ack();
    }

    private void handlePrimaryAck(PrimaryAckCommand command) {
        command.ack();
    }

    private void handleSingleRpcCommand(SingleRpcCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            int commandTopologyId = TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command);
            BlockingRunnable runnable = this.indirectRpc && reply == Reply.NO_OP ? this.createIndirectRpcRunnable(command, commandTopologyId) : this.createReadyActionRunnable(command, reply, commandTopologyId, order.preserveOrder(), this.createReadyAction(commandTopologyId, command));
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command), TopologyMode.WAIT_TX_DATA, order.preserveOrder()).run();
        }
    }

    private BlockingRunnable createIndirectRpcRunnable(SingleRpcCommand command, int commandTopologyId) {
        final WriteCommand writeCommand = (WriteCommand)command.getCommand();
        return new DefaultTopologyRunnable(this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){

            @Override
            protected void onException(Throwable throwable) {
                TrianglePerCacheInboundInvocationHandler.this.sendExceptionAck(writeCommand.getCommandInvocationId(), (Throwable)((Object)new RemoteException("Exception on " + TrianglePerCacheInboundInvocationHandler.this.localAddress, throwable)), this.commandTopologyId);
            }
        };
    }

    private void sendExceptionAck(CommandInvocationId id, Throwable throwable, int topologyId) {
        Address origin = id.getAddress();
        if (trace) {
            log.tracef("Sending exception ack for command %s. Originator=%s.", id, origin);
        }
        if (origin.equals(this.localAddress)) {
            this.commandAckCollector.completeExceptionally(id.getId(), throwable, topologyId);
        } else {
            this.rpcManager.sendTo(origin, this.commandsFactory.buildExceptionAckCommand(id.getId(), throwable, topologyId), DeliverOrder.NONE);
        }
    }

    private void sendBackupAck(CommandInvocationId id, int topologyId) {
        Address origin = id.getAddress();
        boolean isLocal = this.localAddress.equals(origin);
        if (trace) {
            log.tracef("Sending ack for command %s. isLocal? %s.", id, isLocal);
        }
        if (isLocal) {
            this.commandAckCollector.backupAck(id.getId(), origin, topologyId);
        } else {
            this.rpcManager.sendTo(origin, this.commandsFactory.buildBackupAckCommand(id.getId(), topologyId), DeliverOrder.NONE);
        }
    }

    private BlockingRunnable createBackupWriteRpcRunnable(BackupWriteRpcCommand command, int commandTopologyId, final ReadyAction readyAction) {
        readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                readyAction.onException();
                readyAction.onFinally();
                TrianglePerCacheInboundInvocationHandler.this.sendExceptionAck(((BackupWriteRpcCommand)this.command).getCommandInvocationId(), throwable, this.commandTopologyId);
            }

            @Override
            protected void afterInvoke() {
                super.afterInvoke();
                readyAction.onFinally();
                TrianglePerCacheInboundInvocationHandler.this.sendBackupAck(((BackupWriteRpcCommand)this.command).getCommandInvocationId(), this.commandTopologyId);
            }
        };
    }

    private void sendPutMapBackupAck(CommandInvocationId id, int topologyId, int segment) {
        Address origin = id.getAddress();
        if (trace) {
            log.tracef("Sending ack for command %s. Originator=%s.", id, origin);
        }
        if (id.getAddress().equals(this.localAddress)) {
            this.commandAckCollector.multiKeyBackupAck(id.getId(), this.localAddress, segment, topologyId);
        } else {
            BackupMultiKeyAckCommand command = this.commandsFactory.buildBackupMultiKeyAckCommand(id.getId(), segment, topologyId);
            this.rpcManager.sendTo(origin, command, DeliverOrder.NONE);
        }
    }

    private BlockingRunnable createBackupPutMapRunnable(BackupPutMapRpcCommand command, int commandTopologyId, final ReadyAction readyAction) {
        readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                readyAction.onException();
                readyAction.onFinally();
                TrianglePerCacheInboundInvocationHandler.this.sendExceptionAck(((BackupPutMapRpcCommand)this.command).getCommandInvocationId(), throwable, this.commandTopologyId);
            }

            @Override
            protected void afterInvoke() {
                super.afterInvoke();
                readyAction.onFinally();
                Object key = ((BackupPutMapRpcCommand)this.command).getMap().keySet().iterator().next();
                int segment = TrianglePerCacheInboundInvocationHandler.this.clusteringDependentLogic.getCacheTopology().getDistribution(key).segmentId();
                TrianglePerCacheInboundInvocationHandler.this.sendPutMapBackupAck(((BackupPutMapRpcCommand)this.command).getCommandInvocationId(), this.commandTopologyId, segment);
            }
        };
    }

    private ReadyAction createReadyAction(int topologyId, RemoteLockCommand command) {
        if (command.hasSkipLocking()) {
            return null;
        }
        Collection<?> keys = command.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = command.hasZeroLockAcquisition() ? 0L : this.lockTimeout;
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(command, topologyId, timeoutMillis), this, new LockAction(this.lockManager, this.clusteringDependentLogic));
        action.registerListener();
        return action;
    }

    private ReadyAction createReadyAction(int topologyId, SingleRpcCommand singleRpcCommand) {
        ReplicableCommand command = singleRpcCommand.getCommand();
        return command instanceof RemoteLockCommand ? this.createReadyAction(topologyId, (RemoteLockCommand)command) : null;
    }

    private ReadyAction createTriangleOrderAction(ReplicableCommand command, int topologyId, long sequence, Object key) {
        return new DefaultReadyAction(new ActionState(command, topologyId, 0L), this, new TriangleOrderAction(this, sequence, key));
    }
}

