/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

@Scope(value=Scopes.GLOBAL)
public interface Transport
extends Lifecycle {
    @Deprecated
    default public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        CompletableFuture<Map<Address, Response>> future = this.invokeRemotelyAsync(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
        try {
            return CompletableFutures.await(future);
        }
        catch (ExecutionException e) {
            throw Util.rewrapAsCacheException((Throwable)e.getCause());
        }
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> var1, ReplicableCommand var2, ResponseMode var3, long var4, ResponseFilter var6, DeliverOrder var7, boolean var8) throws Exception;

    public void sendTo(Address var1, ReplicableCommand var2, DeliverOrder var3) throws Exception;

    public void sendToMany(Collection<Address> var1, ReplicableCommand var2, DeliverOrder var3) throws Exception;

    @Experimental
    default public void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.sendToMany(null, rpcCommand, deliverOrder);
    }

    @Deprecated
    default public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        DeliverOrder deliverOrder = DeliverOrder.PER_SENDER;
        if (totalOrder) {
            deliverOrder = DeliverOrder.TOTAL;
        } else if (usePriorityQueue) {
            deliverOrder = DeliverOrder.NONE;
        }
        return this.invokeRemotely(rpcCommands, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Deprecated
    default public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, final ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        final ConcurrentHashMap<Address, Response> result = new ConcurrentHashMap<Address, Response>(rpcCommands.size());
        ResponseFilter partResponseFilter = new ResponseFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAcceptable(Response response, Address sender) {
                Map map = result;
                synchronized (map) {
                    result.put(sender, response);
                    return responseFilter.isAcceptable(response, sender);
                }
            }

            @Override
            public boolean needMoreResponses() {
                return responseFilter.needMoreResponses();
            }
        };
        ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(rpcCommands.size());
        for (Map.Entry<Address, ReplicableCommand> e : rpcCommands.entrySet()) {
            futures.add(this.invokeRemotelyAsync(Collections.singleton(e.getKey()), e.getValue(), mode, timeout, partResponseFilter, deliverOrder, anycast));
        }
        try {
            CompletableFutures.await(CompletableFuture.allOf(futures.toArray(new CompletableFuture[rpcCommands.size()])));
            return result;
        }
        catch (ExecutionException e) {
            throw Util.rewrapAsCacheException((Throwable)e.getCause());
        }
    }

    public BackupResponse backupRemotely(Collection<XSiteBackup> var1, XSiteReplicateCommand var2) throws Exception;

    public boolean isCoordinator();

    public Address getCoordinator();

    public Address getAddress();

    public List<Address> getPhysicalAddresses();

    public List<Address> getMembers();

    public boolean isMulticastCapable();

    @Start(priority=10)
    public void start();

    @Stop
    public void stop();

    public int getViewId();

    public CompletableFuture<Void> withView(int var1);

    @Deprecated
    public void waitForView(int var1) throws InterruptedException;

    public Log getLog();

    public void checkTotalOrderSupported();

    public Set<String> getSitesView();

    @Experimental
    default public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.invokeCommand(Collections.singleton(target), command, collector, deliverOrder, timeout, unit);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        try {
            return this.invokeRemotelyAsync(targets, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, unit.toMillis(timeout), null, deliverOrder, false).thenApply(map -> {
                for (Map.Entry e : map.entrySet()) {
                    Object result = collector.addResponse((Address)e.getKey(), (Response)e.getValue());
                    if (result == null) continue;
                    return result;
                }
                return collector.finish();
            });
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.invokeCommand(this.getMembers(), command, collector, deliverOrder, timeout, unit);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, final ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        try {
            ResponseFilter responseFilter = new ResponseFilter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isAcceptable(Response response, Address sender) {
                    AtomicReference atomicReference = result;
                    synchronized (atomicReference) {
                        if (result.get() != null) {
                            return false;
                        }
                        Object t = collector.addResponse(sender, response);
                        result.set(t);
                        return t != null;
                    }
                }

                @Override
                public boolean needMoreResponses() {
                    return result.get() == null;
                }
            };
            return this.invokeRemotelyAsync(targets, command, ResponseMode.WAIT_FOR_VALID_RESPONSE, unit.toMillis(timeout), responseFilter, deliverOrder, false).thenApply(map -> {
                AtomicReference atomicReference = result;
                synchronized (atomicReference) {
                    if (result.get() != null) {
                        return result.get();
                    }
                    result.set(new Object());
                    return collector.finish();
                }
            });
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
    }

    @Deprecated
    default public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> responseCollector, long timeout, DeliverOrder deliverOrder) {
        return this.invokeCommands(targets, commandGenerator, responseCollector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, final ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        ResponseCollector partCollector = new ResponseCollector<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T addResponse(Address sender, Response response) {
                3 var3_3 = this;
                synchronized (var3_3) {
                    if (result.get() != null) {
                        return null;
                    }
                    result.set(collector.addResponse(sender, response));
                    return null;
                }
            }

            @Override
            public T finish() {
                return null;
            }
        };
        ArrayList<CompletableFuture<T>> futures = new ArrayList<CompletableFuture<T>>(targets.size());
        for (Address target : targets) {
            futures.add(this.invokeCommand(target, commandGenerator.apply(target), partCollector, deliverOrder, timeout, timeUnit).toCompletableFuture());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[targets.size()])).thenApply(v -> {
            ResponseCollector responseCollector = partCollector;
            synchronized (responseCollector) {
                if (result.get() != null) {
                    return result.get();
                }
                return collector.finish();
            }
        });
    }
}

