/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class StreamResponseCommand<R>
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 48;
    protected ClusterStreamManager csm;
    protected Object id;
    protected boolean complete;
    protected R response;

    protected StreamResponseCommand() {
        super(null);
    }

    public StreamResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamResponseCommand(ByteString cacheName, Address origin, Object id, boolean complete, R response) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
        this.complete = complete;
        this.response = response;
    }

    @Inject
    public void inject(ClusterStreamManager csm) {
        this.csm = csm;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.csm.receiveResponse(this.id, this.getOrigin(), this.complete, Collections.emptySet(), this.response);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 48;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeObject(this.id);
        output.writeBoolean(this.complete);
        output.writeObject(this.response);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.id = input.readObject();
        this.complete = input.readBoolean();
        this.response = input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StreamResponseCommand{");
        sb.append("id=").append(this.id);
        sb.append(", complete=").append(this.complete);
        sb.append(", response=").append(this.response);
        sb.append('}');
        return sb.toString();
    }
}

