/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.concurrent.Executor;
import org.jboss.as.connector.services.workmanager.NamedWorkManager;
import org.jboss.as.connector.services.workmanager.WorkManagerService;
import org.jboss.as.connector.services.workmanager.statistics.WorkManagerStatisticsService;
import org.jboss.as.connector.subsystems.jca.JcaWorkManagerDefinition;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;

public class WorkManagerAdd
extends AbstractAddStepHandler {
    public static final WorkManagerAdd INSTANCE = new WorkManagerAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (JcaWorkManagerDefinition.WmParameters parameter : JcaWorkManagerDefinition.WmParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String name = JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().resolveModelAttribute(context, resource.getModel()).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        NamedWorkManager wm = new NamedWorkManager(name);
        WorkManagerService wmService = new WorkManagerService((WorkManager)wm);
        ServiceBuilder builder = serviceTarget.addService(ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{name}), (Service)wmService);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ThreadsServices.EXECUTOR.append(new String[]{"long-running-threads"}).append(new String[]{name}), Executor.class, wmService.getExecutorLongInjector());
        builder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{"short-running-threads"}).append(new String[]{name}), Executor.class, wmService.getExecutorShortInjector());
        builder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, wmService.getXaTerminatorInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        WorkManagerStatisticsService wmStatsService = new WorkManagerStatisticsService(context.getResourceRegistrationForUpdate(), name, true);
        serviceTarget.addService(ConnectorServices.WORKMANAGER_STATS_SERVICE.append(new String[]{name}), (Service)wmStatsService).addDependency(ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{name}), WorkManager.class, wmStatsService.getWorkManagerInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
        PathElement peLocaldWm = PathElement.pathElement((String)"statistics", (String)"local");
        IronJacamarResource.IronJacamarRuntimeResource wmResource = new IronJacamarResource.IronJacamarRuntimeResource();
        if (!resource.hasChild(peLocaldWm)) {
            resource.registerChild(peLocaldWm, (Resource)wmResource);
        }
    }
}

