/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.elasticsearch.impl.NestingMarker;
import org.hibernate.search.elasticsearch.util.impl.ParentPathMismatchException;
import org.hibernate.search.elasticsearch.util.impl.PathComponentExtractor;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;

final class JsonAccessorBuilder {
    private UnknownTypeJsonAccessor currentAccessor = null;
    private final Deque<Integer> indexes = new ArrayDeque<Integer>();
    private final PathComponentExtractor pathComponentExtractor = new PathComponentExtractor();

    JsonAccessorBuilder() {
    }

    public void reset() {
        this.indexes.clear();
        this.pathComponentExtractor.reset();
        this.currentAccessor = null;
    }

    public void append(List<NestingMarker.NestingPathComponent> nestingPath) {
        if (nestingPath == null) {
            return;
        }
        for (NestingMarker.NestingPathComponent pathComponent : nestingPath) {
            UnknownTypeJsonAccessor newAccessor;
            EmbeddedTypeMetadata embeddedTypeMetadata = pathComponent.getEmbeddedTypeMetadata();
            this.pathComponentExtractor.append(embeddedTypeMetadata.getEmbeddedFieldPrefix());
            Integer currentComponentArrayIndex = pathComponent.getIndex();
            if (currentComponentArrayIndex != null) {
                this.indexes.addLast(currentComponentArrayIndex);
            }
            if ((newAccessor = this.consumePath(this.pathComponentExtractor, PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST)) == this.currentAccessor) continue;
            this.currentAccessor = newAccessor;
            this.indexes.clear();
        }
    }

    private UnknownTypeJsonAccessor consumePath(PathComponentExtractor extractor, PathComponentExtractor.ConsumptionLimit consumptionLimit) {
        boolean consumeIndexes;
        String childName = extractor.next(consumptionLimit);
        UnknownTypeJsonAccessor newAccessor = this.currentAccessor;
        boolean bl = consumeIndexes = !this.indexes.isEmpty();
        while (childName != null) {
            newAccessor = newAccessor == null ? JsonAccessor.root().property(childName) : newAccessor.property(childName);
            if (consumeIndexes) {
                for (Integer index : this.indexes) {
                    newAccessor = newAccessor.element(index);
                }
                consumeIndexes = false;
            }
            childName = extractor.next(consumptionLimit);
        }
        return newAccessor;
    }

    public UnknownTypeJsonAccessor buildForPath(String absolutePath) throws ParentPathMismatchException {
        PathComponentExtractor newExtractor = this.pathComponentExtractor.clone();
        newExtractor.appendRelativePart(absolutePath);
        return this.consumePath(newExtractor, PathComponentExtractor.ConsumptionLimit.LAST);
    }
}

