/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkExecutionContext;
import org.hibernate.search.exception.ErrorHandler;

class IndexMonitorBufferingElasticsearchWorkExecutionContext
implements FlushableElasticsearchWorkExecutionContext {
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    protected final ErrorHandler errorHandler;
    private final Map<IndexingMonitor, BufferedIndexingMonitor> bufferedIndexMonitors = new HashMap<IndexingMonitor, BufferedIndexingMonitor>();

    public IndexMonitorBufferingElasticsearchWorkExecutionContext(ElasticsearchClient client, GsonProvider gsonProvider, ErrorHandler errorHandler) {
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.errorHandler = errorHandler;
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }

    @Override
    public GsonProvider getGsonProvider() {
        return this.gsonProvider;
    }

    @Override
    public void setIndexDirty(URLEncodedString indexName) {
    }

    @Override
    public IndexingMonitor getBufferedIndexingMonitor(IndexingMonitor originalMonitor) {
        return this.bufferedIndexMonitors.computeIfAbsent(originalMonitor, BufferedIndexingMonitor::new);
    }

    @Override
    public CompletableFuture<Void> flush() {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        return future.thenRun(() -> {
            for (BufferedIndexingMonitor buffer : this.bufferedIndexMonitors.values()) {
                try {
                    buffer.flush();
                }
                catch (RuntimeException e) {
                    this.errorHandler.handleException("Flushing an indexing monitor failed", (Throwable)e);
                }
            }
            this.bufferedIndexMonitors.clear();
        });
    }

    private static final class BufferedIndexingMonitor
    implements IndexingMonitor {
        private final IndexingMonitor delegate;
        private long documentsAdded = 0L;

        public BufferedIndexingMonitor(IndexingMonitor delegate) {
            this.delegate = delegate;
        }

        public void documentsAdded(long increment) {
            this.documentsAdded += increment;
        }

        private void flush() {
            this.delegate.documentsAdded(this.documentsAdded);
            this.documentsAdded = 0L;
        }
    }
}

