/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ThrowingUnsupportedParameterValueTransformer
implements ParameterValueTransformer {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final Class<?> factoryClass;
    private final String parameterName;

    ThrowingUnsupportedParameterValueTransformer(Class<?> factoryClass, String parameterName) {
        this.factoryClass = factoryClass;
        this.parameterName = parameterName;
    }

    @Override
    public JsonElement transform(String parameterValue) {
        throw log.unsupportedAnalysisFactoryParameter(this.factoryClass, this.parameterName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.factoryClass + "," + this.parameterName + "]";
    }
}

