/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.impl.Futures;
import org.hibernate.search.util.impl.Throwables;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class SimpleElasticsearchWork<R>
implements ElasticsearchWork<R> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final CompletableFuture<Void> SUCCESSFUL_FUTURE = CompletableFuture.completedFuture(null);
    protected final ElasticsearchRequest request;
    private final LuceneWork luceneWork;
    protected final URLEncodedString dirtiedIndexName;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;
    protected final boolean markIndexDirty;

    protected SimpleElasticsearchWork(Builder<?> builder) {
        this.request = builder.buildRequest();
        this.luceneWork = builder.luceneWork;
        this.dirtiedIndexName = builder.dirtiedIndexName;
        this.resultAssessor = builder.resultAssessor;
        this.markIndexDirty = builder.markIndexDirty;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "path = " + this.request.getPath() + ", dirtiedIndexName = " + this.dirtiedIndexName + "]";
    }

    @Override
    public final CompletableFuture<R> execute(ElasticsearchWorkExecutionContext executionContext) {
        return ((CompletableFuture)((CompletableFuture)Futures.create(() -> this.beforeExecute(executionContext, this.request)).thenCompose(ignored -> executionContext.getClient().submit(this.request))).exceptionally(Futures.handler(throwable -> {
            throw LOG.elasticsearchRequestFailed(this.request, null, Throwables.expectException((Throwable)throwable));
        }))).thenCompose(response -> this.handleResult(executionContext, (ElasticsearchResponse)response));
    }

    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return SUCCESSFUL_FUTURE;
    }

    protected CompletableFuture<?> afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        return SUCCESSFUL_FUTURE;
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, ElasticsearchResponse var2);

    @Override
    public void aggregate(ElasticsearchWorkAggregator aggregator) {
        aggregator.addNonBulkable(this);
    }

    @Override
    public LuceneWork getLuceneWork() {
        return this.luceneWork;
    }

    private CompletableFuture<R> handleResult(ElasticsearchWorkExecutionContext executionContext, ElasticsearchResponse response) {
        Object result;
        try {
            this.resultAssessor.checkSuccess(response);
            result = this.generateResult(executionContext, response);
            if (this.markIndexDirty) {
                executionContext.setIndexDirty(this.dirtiedIndexName);
            }
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchRequestFailed(this.request, response, e);
        }
        return ((CompletableFuture)this.afterSuccess(executionContext).exceptionally(Futures.handler(throwable -> {
            throw LOG.elasticsearchRequestFailed(this.request, response, Throwables.expectException((Throwable)throwable));
        }))).thenApply(ignored -> result);
    }

    protected static abstract class Builder<B> {
        protected final URLEncodedString dirtiedIndexName;
        protected ElasticsearchRequestSuccessAssessor resultAssessor;
        protected LuceneWork luceneWork;
        protected boolean markIndexDirty;

        public Builder(URLEncodedString dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            this.dirtiedIndexName = dirtiedIndexName;
            this.resultAssessor = resultAssessor;
        }

        public B luceneWork(LuceneWork luceneWork) {
            this.luceneWork = luceneWork;
            return (B)this;
        }

        public B markIndexDirty(boolean markIndexDirty) {
            this.markIndexDirty = markIndexDirty;
            return (B)this;
        }

        protected abstract ElasticsearchRequest buildRequest();

        public abstract ElasticsearchWork<?> build();
    }
}

