/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.kubernetes.Client;
import org.jgroups.protocols.kubernetes.Pod;
import org.jgroups.protocols.kubernetes.Utils;
import org.jgroups.protocols.kubernetes.stream.BaseStreamProvider;
import org.jgroups.protocols.kubernetes.stream.CertificateStreamProvider;
import org.jgroups.protocols.kubernetes.stream.InsecureStreamProvider;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;

@MBean(description="Kubernetes based discovery protocol")
public class KUBE_PING
extends Discovery {
    protected static final short KUBERNETES_PING_ID = 2017;
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    protected int port_range = 1;
    @Property(description="Max time (in millis) to wait for a connection to the Kubernetes server. If exceeded, an exception will be thrown", systemProperty={"KUBERNETES_CONNECT_TIMEOUT"})
    protected int connectTimeout = 5000;
    @Property(description="Max time (in millis) to wait for a response from the Kubernetes server", systemProperty={"KUBERNETES_READ_TIMEOUT"})
    protected int readTimeout = 30000;
    @Property(description="Max number of attempts to send discovery requests", systemProperty={"KUBERNETES_OPERATION_ATTEMPTS"})
    protected int operationAttempts = 3;
    @Property(description="Time (in millis) between operation attempts", systemProperty={"KUBERNETES_OPERATION_SLEEP"})
    protected long operationSleep = 1000L;
    @Property(description="https (default) or http. Used to send the initial discovery request to the Kubernetes server", systemProperty={"KUBERNETES_MASTER_PROTOCOL"})
    protected String masterProtocol = "https";
    @Property(description="The URL of the Kubernetes server", systemProperty={"KUBERNETES_SERVICE_HOST"})
    protected String masterHost;
    @Property(description="The port on which the Kubernetes server is listening", systemProperty={"KUBERNETES_SERVICE_PORT"})
    protected int masterPort;
    @Property(description="The version of the protocol to the Kubernetes server", systemProperty={"KUBERNETES_API_VERSION"})
    protected String apiVersion = "v1";
    @Property(description="namespace", systemProperty={"KUBERNETES_NAMESPACE"})
    protected String namespace = "default";
    @Property(description="The labels to use in the discovery request to the Kubernetes server", systemProperty={"KUBERNETES_LABELS"})
    protected String labels;
    @Property(description="Certificate to access the Kubernetes server", systemProperty={"KUBERNETES_CLIENT_CERTIFICATE_FILE"})
    protected String clientCertFile;
    @Property(description="Client key file (store)", systemProperty={"KUBERNETES_CLIENT_KEY_FILE"})
    protected String clientKeyFile;
    @Property(description="The password to access the client key store", systemProperty={"KUBERNETES_CLIENT_KEY_PASSWORD"})
    protected String clientKeyPassword;
    @Property(description="The algorithm used by the client", systemProperty={"KUBERNETES_CLIENT_KEY_ALGO"})
    protected String clientKeyAlgo = "RSA";
    @Property(description="Client CA certificate", systemProperty={"KUBERNETES_CA_CERTIFICATE_FILE"})
    protected String caCertFile;
    @Property(description="Token file", systemProperty={"SA_TOKEN_FILE"})
    protected String saTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    @Property(description="Dumps all discovery requests and responses to the Kubernetes server to stdout when true")
    protected boolean dump_requests;
    @Property(description="The standard behavior during Rolling Update is to put all Pods in the same cluster. In cases (application level incompatibility) this causes problems. One might decide to split clusters to 'old' and 'new' during that process")
    protected boolean split_clusters_during_rolling_update;
    protected Client client;
    protected int tp_bind_port;

    public boolean isDynamic() {
        return false;
    }

    public void setMasterHost(String masterMost) {
        this.masterHost = masterMost;
    }

    public void setMasterPort(int masterPort) {
        this.masterPort = masterPort;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected boolean isClusteringEnabled() {
        return this.namespace != null;
    }

    public void init() throws Exception {
        BaseStreamProvider streamProvider;
        super.init();
        TP transport = this.getTransport();
        this.tp_bind_port = transport.getBindPort();
        if (this.tp_bind_port <= 0) {
            throw new IllegalArgumentException(String.format("%s only works with  %s.bind_port > 0", KUBE_PING.class.getSimpleName(), transport.getClass().getSimpleName()));
        }
        if (this.namespace == null) {
            this.log.warn("namespace not set; clustering disabled");
            return;
        }
        this.log.info("namespace %s set; clustering enabled", new Object[]{this.namespace});
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.clientCertFile != null) {
            if (this.masterProtocol == null) {
                this.masterProtocol = "http";
            }
            streamProvider = new CertificateStreamProvider(this.clientCertFile, this.clientKeyFile, this.clientKeyPassword, this.clientKeyAlgo, this.caCertFile);
        } else {
            String saToken = Utils.readFileToString(this.saTokenFile);
            if (saToken != null) {
                headers.put("Authorization", "Bearer " + saToken);
            }
            streamProvider = new InsecureStreamProvider();
        }
        String url = String.format("%s://%s:%s/api/%s", this.masterProtocol, this.masterHost, this.masterPort, this.apiVersion);
        this.client = new Client(url, headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, streamProvider, this.log);
        this.log.debug("KubePING configuration: " + this.toString());
    }

    public void destroy() {
        this.client = null;
        super.destroy();
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        Collection list;
        List<Pod> hosts = this.readAll();
        ArrayList<IpAddress> cluster_members = new ArrayList<IpAddress>(hosts != null ? hosts.size() : 16);
        PhysicalAddress physical_addr = null;
        PingData data = null;
        if (!this.use_ip_addrs || !initial_discovery) {
            physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
            data = new PingData(this.local_addr, false, NameCache.get((Address)this.local_addr), physical_addr);
            if (members != null && members.size() <= this.max_members_in_discovery_request) {
                data.mbrs(members);
            }
        }
        if (hosts != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: hosts fetched from Kubernetes: %s", new Object[]{this.local_addr, hosts});
            }
            for (Pod host : hosts) {
                for (int i = 0; i <= this.port_range; ++i) {
                    try {
                        IpAddress addr = new IpAddress(host.getIp(), this.tp_bind_port + i);
                        if (cluster_members.contains(addr)) continue;
                        cluster_members.add(addr);
                        continue;
                    }
                    catch (Exception ex) {
                        this.log.warn("failed translating host %s into InetAddress: %s", new Object[]{host, ex});
                    }
                }
            }
        }
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            list.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        }
        if (this.split_clusters_during_rolling_update) {
            if (physical_addr != null) {
                String senderIp = ((IpAddress)physical_addr).getIpAddress().getHostAddress();
                String senderParentDeployment = hosts.stream().filter(pod -> senderIp.contains(pod.getIp())).map(Pod::getParentDeployment).findFirst().orElse(null);
                if (senderParentDeployment != null) {
                    Set set = hosts.stream().filter(pod -> senderParentDeployment.equals(pod.getParentDeployment())).map(Pod::getIp).collect(Collectors.toSet());
                    Iterator memberIterator = cluster_members.iterator();
                    while (memberIterator.hasNext()) {
                        IpAddress podAddress = (IpAddress)memberIterator.next();
                        if (set.contains(podAddress.getIpAddress().getHostAddress())) continue;
                        this.log.trace("removing pod %s from cluster members list since its parent domain is different than senders (%s). Allowed hosts: %s", new Object[]{podAddress, senderParentDeployment, set});
                        memberIterator.remove();
                    }
                } else {
                    this.log.warn("split_clusters_during_rolling_update is set to 'true' but can't obtain local node parent deployment. All nodes will be placed in the same cluster.");
                }
            } else {
                this.log.warn("split_clusters_during_rolling_update is set to 'true' but can't obtain local node IP address. All nodes will be placed in the same cluster.");
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: sending discovery requests to %s", new Object[]{this.local_addr, cluster_members});
        }
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name).initialDiscovery(initial_discovery);
        for (PhysicalAddress physicalAddress : cluster_members) {
            if (physical_addr != null && physicalAddress.equals(physical_addr)) continue;
            Message msg = new Message((Address)physicalAddress).setFlag(new Message.Flag[]{Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB}).putHeader(this.id, (Header)hdr);
            if (data != null) {
                msg.setBuffer(KUBE_PING.marshal((PingData)data));
            }
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> this.sendDiscoveryRequest(msg), this.sends_can_block);
                continue;
            }
            this.sendDiscoveryRequest(msg);
        }
    }

    @ManagedOperation(description="Asks Kubernetes for the IP addresses of all pods")
    public String fetchFromKube() {
        List<Pod> list = this.readAll();
        return list.toString();
    }

    protected List<Pod> readAll() {
        if (this.isClusteringEnabled() && this.client != null) {
            try {
                return this.client.getPods(this.namespace, this.labels, this.dump_requests);
            }
            catch (Exception e) {
                this.log.warn("failed getting JSON response from Kubernetes %s for cluster [%s], namespace [%s], labels [%s]; encountered [%s: %s]", new Object[]{this.client.info(), this.cluster_name, this.namespace, this.labels, e.getClass().getName(), e.getMessage()});
            }
        }
        return Collections.emptyList();
    }

    protected void sendDiscoveryRequest(Message req) {
        try {
            this.down_prot.down(req);
        }
        catch (Throwable t) {
            this.log.trace("sending discovery request to %s failed: %s", new Object[]{req.dest(), t});
        }
    }

    public String toString() {
        return String.format("KubePing{namespace='%s', labels='%s'}", this.namespace, this.labels);
    }

    static {
        ClassConfigurator.addProtocol((short)2017, KUBE_PING.class);
    }
}

