/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.counter.operation.AddListenerOperation;
import org.infinispan.client.hotrod.counter.operation.RemoveListenerOperation;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.Util;

public class ConnectionManager {
    private static final Log log = LogFactory.getLog(ConnectionManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean debug = log.isDebugEnabled();
    private final byte[] listenerId;
    private final CounterOperationFactory factory;
    private final Consumer<HotRodCounterEvent> eventConsumer;
    private final Codec codec;
    private final ExecutorService executor;
    @GuardedBy(value="this")
    private final Set<String> registeredCounters;
    @GuardedBy(value="this")
    private EventDispatcher dispatcher;

    ConnectionManager(CounterOperationFactory factory, Consumer<HotRodCounterEvent> eventConsumer) {
        this.factory = factory;
        this.codec = factory.getCodec();
        this.eventConsumer = eventConsumer;
        this.listenerId = new byte[16];
        ThreadLocalRandom.current().nextBytes(this.listenerId);
        this.executor = Executors.newCachedThreadPool(ClientListenerNotifier.getRestoreThreadNameThreadFactory());
        this.registeredCounters = new HashSet<String>();
    }

    private static void debugMessage(String message) {
        if (debug) {
            log.debug(message);
        }
    }

    public synchronized void failedServers(Collection<SocketAddress> failedServers) {
        if (failedServers.contains(this.getServerInUse())) {
            this.findAnotherServer();
        }
    }

    public synchronized void stop() {
        this.removeConnection("");
        this.cleanupDispatcher();
        this.executor.shutdownNow();
    }

    synchronized void addConnection(String counterName) {
        this.createConnection(counterName);
        this.registeredCounters.add(counterName);
    }

    synchronized void removeConnection(String counterName) {
        RemoveListenerOperation op;
        if (trace) {
            log.tracef("Remove listener connection for counter '%s'", counterName);
        }
        if (((Boolean)(op = this.factory.newRemoveListenerOperation(counterName, this.listenerId, this.getServerInUse())).execute()).booleanValue()) {
            this.cleanupDispatcher();
        }
        this.registeredCounters.remove(counterName);
    }

    private void createConnection(String counterName) {
        AddListenerOperation op = this.factory.newAddListenerOperation(counterName, this.listenerId, this.getServerInUse());
        if (((Boolean)op.execute()).booleanValue()) {
            this.cleanupDispatcher();
            this.dispatcher = new EventDispatcher(op.getDedicatedTransport());
            if (trace) {
                log.tracef("Add listener connection for counter '%s'. Server used=%s", counterName, this.getServerInUse());
            }
            this.executor.execute(this.dispatcher);
        }
    }

    private SocketAddress getServerInUse() {
        return this.dispatcher == null ? null : this.dispatcher.transport.getRemoteSocketAddress();
    }

    private void cleanupDispatcher() {
        if (this.dispatcher != null) {
            this.dispatcher.run = false;
            this.dispatcher.transport.release();
            this.dispatcher = null;
        }
    }

    private String getThreadName() {
        return "Counter-Listener-" + Util.toHexString((byte[])this.listenerId, (int)8);
    }

    private synchronized void findAnotherServer() {
        this.cleanupDispatcher();
        try {
            if (debug) {
                log.debug("Connection reset by peer, finding another server for counter listeners");
            }
            this.registeredCounters.forEach(this::createConnection);
        }
        catch (TransportException e) {
            if (debug) {
                log.debug("Unable to find another server, so ignore connection reset");
            }
            try {
                this.factory.geTransportFactory().addDisconnectedListener(this::findAnotherServer);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class EventDispatcher
    implements Runnable {
        private final Transport transport;
        public volatile boolean run = true;

        private EventDispatcher(Transport transport) {
            this.transport = transport;
        }

        @Override
        public void run() {
            Thread.currentThread().setName(ConnectionManager.this.getThreadName());
            while (this.run && !Thread.currentThread().isInterrupted()) {
                HotRodCounterEvent event = null;
                try {
                    event = ConnectionManager.this.codec.readCounterEvent(this.transport, ConnectionManager.this.listenerId);
                    ConnectionManager.this.eventConsumer.accept(event);
                    event = null;
                }
                catch (TransportException e) {
                    this.handleTransportException(e, event);
                }
                catch (CancelledKeyException e) {
                    ConnectionManager.debugMessage("Key cancelled, most likely channel closed, exiting event reader thread");
                    this.run = false;
                }
                catch (Throwable t) {
                    this.handleException(t, event);
                }
            }
            if (trace) {
                log.trace("Dispatcher thread stopped!");
            }
        }

        private void handleException(Throwable t, HotRodCounterEvent event) {
            if (event != null) {
                log.unexpectedErrorConsumingEvent(event, t);
            } else {
                log.unableToReadEventFromServer(t, this.transport.getRemoteSocketAddress());
            }
            if (!this.transport.isValid()) {
                this.run = false;
            }
        }

        private void handleTransportException(TransportException e, HotRodCounterEvent event) {
            Throwable cause = e.getCause();
            if (cause instanceof ClosedChannelException || cause instanceof SocketException && !this.transport.isValid()) {
                ConnectionManager.debugMessage("Channel closed, exiting event reader thread");
                this.run = false;
            } else if (cause instanceof SocketTimeoutException) {
                ConnectionManager.debugMessage("Timed out reading event, retry");
            } else if (event != null) {
                log.unexpectedErrorConsumingEvent(event, e);
            } else if (cause instanceof IOException && cause.getMessage().contains("Connection reset by peer")) {
                ConnectionManager.this.findAnotherServer();
                this.run = false;
            } else {
                log.unrecoverableErrorReadingEvent(e, this.transport.getRemoteSocketAddress());
                this.run = false;
            }
        }
    }
}

