/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;

public class CompareAndSwapOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(CompareAndSwapOperation.class, Log.class);
    private final long expect;
    private final long update;
    private final CounterConfiguration counterConfiguration;

    public CompareAndSwapOperation(Codec codec, TransportFactory transportFactory, AtomicInteger topologyId, Configuration cfg, String counterName, long expect, long update, CounterConfiguration counterConfiguration) {
        super(codec, transportFactory, topologyId, cfg, counterName);
        this.expect = expect;
        this.update = update;
        this.counterConfiguration = counterConfiguration;
    }

    @Override
    protected Long executeOperation(Transport transport) {
        HeaderParams header = this.writeHeaderAndCounterName(transport, (short)88);
        transport.writeLong(this.expect);
        transport.writeLong(this.update);
        transport.flush();
        short status = this.readHeaderAndValidateCounter(transport, header);
        this.assertBoundaries(status);
        assert (status == 0);
        return transport.readLong();
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.update >= this.counterConfiguration.upperBound()) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

