/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class RemoveListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;

    public RemoveListenerOperation(Codec codec, TransportFactory transportFactory, AtomicInteger topologyId, Configuration cfg, String counterName, byte[] listenerId, SocketAddress server) {
        super(codec, transportFactory, topologyId, cfg, counterName);
        this.listenerId = listenerId;
        this.server = server;
    }

    @Override
    protected Boolean executeOperation(Transport transport) {
        HeaderParams header = this.writeHeaderAndCounterName(transport, (short)90);
        transport.writeArray(this.listenerId);
        transport.flush();
        short status = this.readHeaderAndValidateCounter(transport, header);
        return status == 0;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.server == null ? super.getTransport(retryCount, failedServers) : this.transportFactory.getAddressTransport(this.server);
    }
}

