/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.protocol.MultimapHeaderParams;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class ContainsValueMultimapOperation
extends RetryOnFailureOperation<Boolean> {
    protected final byte[] value;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;

    protected ContainsValueMultimapOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, transportFactory, cacheName, topologyId, flags, cfg);
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    protected HeaderParams createHeader() {
        return new MultimapHeaderParams();
    }

    @Override
    protected Transport getTransport(int retryCount, Set failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected Boolean executeOperation(Transport transport) {
        short status = this.sendValueOperation(transport, (short)119, (short)120);
        if (HotRodConstants.isNotExist(status)) {
            return Boolean.FALSE;
        }
        return transport.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected short sendValueOperation(Transport transport, short opCode, short opRespCode) {
        HeaderParams params = this.writeHeader(transport, opCode);
        this.codec.writeExpirationParams(transport, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        transport.writeArray(this.value);
        transport.flush();
        return this.readHeaderAndValidate(transport, params);
    }
}

