/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.metadata.MetadataCollectionImpl;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.multimap.MetadataCollection;

@Immutable
public class GetKeyWithMetadataMultimapOperation<V>
extends AbstractMultimapKeyOperation<MetadataCollection<V>> {
    private static final Log log = LogFactory.getLog(GetKeyWithMetadataMultimapOperation.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetKeyWithMetadataMultimapOperation(Codec codec, TransportFactory transportFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, transportFactory, key, keyBytes, cacheName, topologyId, flags, cfg);
    }

    @Override
    protected MetadataCollection<V> executeOperation(Transport transport) {
        short status = this.sendKeyOperation(this.keyBytes, transport, (short)105, (short)106);
        MetadataCollectionImpl<Object> result = null;
        if (HotRodConstants.isNotExist(status)) {
            result = new MetadataCollectionImpl(Collections.emptySet());
        } else if (HotRodConstants.isSuccess(status)) {
            short flags = transport.readByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = transport.readLong();
                lifespan = transport.readVInt();
            }
            if ((flags & 2) != 2) {
                lastUsed = transport.readLong();
                maxIdle = transport.readVInt();
            }
            long version = transport.readLong();
            if (trace) {
                log.tracef("Received version: %d", version);
            }
            int size = transport.readVInt();
            ArrayList values = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                Object value = this.codec.readUnmarshallByteArray(transport, status, this.cfg.serialWhitelist());
                values.add(value);
            }
            result = new MetadataCollectionImpl(values, creation, lifespan, lastUsed, maxIdle, version);
        }
        return result;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(this.key, failedServers, this.cacheName);
    }
}

