/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;

@Immutable
public abstract class HotRodOperation
implements HotRodConstants {
    protected final int flags;
    public final byte[] cacheName;
    protected final AtomicInteger topologyId;
    protected final Codec codec;
    protected final Configuration cfg;
    private static final byte NO_TX = 0;
    private static final byte XA_TX = 1;

    protected HotRodOperation(Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicInteger topologyId) {
        this.flags = flags;
        this.cfg = cfg;
        this.cacheName = cacheName;
        this.topologyId = topologyId;
        this.codec = codec;
    }

    public abstract Object execute();

    protected final HeaderParams writeHeader(Transport transport, short operationCode) {
        HeaderParams params = this.createHeader().opCode(operationCode).cacheName(this.cacheName).flags(this.flags).clientIntel(this.cfg.clientIntelligence()).topologyId(this.topologyId).txMarker((byte)0).topologyAge(transport.getTransportFactory().getTopologyAge());
        return this.codec.writeHeader(transport, params);
    }

    protected short readHeaderAndValidate(Transport transport, HeaderParams params) {
        return this.codec.readHeader(transport, params);
    }

    protected HeaderParams createHeader() {
        return new HeaderParams();
    }
}

