/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.configuration.AbstractCounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.logging.Log;
import org.infinispan.counter.util.Utils;

public class StrongCounterConfigurationBuilder
extends AbstractCounterConfigurationBuilder<StrongCounterConfiguration, StrongCounterConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(StrongCounterConfigurationBuilder.class, Log.class);

    StrongCounterConfigurationBuilder(CounterManagerConfigurationBuilder builder) {
        super(builder, StrongCounterConfiguration.attributeDefinitionSet());
    }

    public StrongCounterConfigurationBuilder upperBound(long value) {
        this.attributes.attribute(StrongCounterConfiguration.UPPER_BOUND).set((Object)value);
        return this.self();
    }

    public StrongCounterConfigurationBuilder lowerBound(long value) {
        this.attributes.attribute(StrongCounterConfiguration.LOWER_BOUND).set((Object)value);
        return this.self();
    }

    public StrongCounterConfiguration create() {
        return new StrongCounterConfiguration(this.attributes);
    }

    public Builder<?> read(StrongCounterConfiguration template) {
        this.attributes.read(template.attributes());
        return this.self();
    }

    public StrongCounterConfigurationBuilder self() {
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.attributes.attribute(StrongCounterConfiguration.LOWER_BOUND).isModified() || this.attributes.attribute(StrongCounterConfiguration.UPPER_BOUND).isModified()) {
            long min = (Long)this.attributes.attribute(StrongCounterConfiguration.LOWER_BOUND).get();
            long max = (Long)this.attributes.attribute(StrongCounterConfiguration.UPPER_BOUND).get();
            long init = (Long)this.attributes.attribute(StrongCounterConfiguration.INITIAL_VALUE).get();
            if (Utils.isValid(min, init, max)) {
                throw log.invalidInitialValueForBoundedCounter(min, max, init);
            }
        }
    }
}

