/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.listener;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.commons.util.ByRef;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterEventGenerator;
import org.infinispan.counter.impl.listener.CounterKeyFilter;
import org.infinispan.counter.impl.listener.TopologyChangeListener;
import org.infinispan.counter.logging.Log;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.filter.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.LogFactory;

public class CounterManagerNotificationManager {
    private static final Log log = (Log)LogFactory.getLog(CounterManagerNotificationManager.class, Log.class);
    private final Map<ByteString, Holder> counters;
    private volatile Executor userListenerExecutor = new WithinThreadExecutor();
    private boolean listenersRegistered;

    public CounterManagerNotificationManager() {
        this.counters = new ConcurrentHashMap<ByteString, Holder>();
    }

    public void useExecutor(Executor asyncExecutor) {
        if (asyncExecutor == null) {
            return;
        }
        this.userListenerExecutor = new LimitedExecutor("counter-listener", asyncExecutor, 1);
    }

    public void registerCounter(ByteString counterName, CounterEventGenerator generator, TopologyChangeListener topologyChangeListener) {
        if (this.counters.putIfAbsent(counterName, new Holder(generator, topologyChangeListener)) != null) {
            throw new IllegalStateException();
        }
    }

    public <T extends CounterListener> Handle<T> registerUserListener(ByteString counterName, T userListener) {
        ByRef handleByRef = new ByRef(null);
        this.counters.computeIfPresent(counterName, (name, holder) -> holder.addListener(userListener, handleByRef));
        return (Handle)handleByRef.get();
    }

    public synchronized void listenOn(Cache<? extends CounterKey, CounterValue> cache) {
        if (!this.listenersRegistered) {
            cache.addListener((Object)new CounterValueListener(), (KeyFilter)CounterKeyFilter.getInstance());
            cache.addListener((Object)new TopologyListener());
            this.listenersRegistered = true;
        }
    }

    public void removeCounter(ByteString counterName) {
        this.counters.remove(counterName);
    }

    @Listener(sync=false)
    private class TopologyListener {
        private TopologyListener() {
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<?, ?> event) {
            CounterManagerNotificationManager.this.counters.values().parallelStream().map(Holder::getTopologyChangeListener).filter(Objects::nonNull).forEach(TopologyChangeListener::topologyChanged);
        }
    }

    @Listener(clustered=true, observation=Listener.Observation.POST)
    private class CounterValueListener {
        private CounterValueListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void updateState(CacheEntryEvent<? extends CounterKey, CounterValue> event) {
            CounterKey key = (CounterKey)event.getKey();
            Holder holder = (Holder)CounterManagerNotificationManager.this.counters.get(key.getCounterName());
            if (holder == null) {
                return;
            }
            CounterEventGenerator counterEventGenerator = holder.generator;
            synchronized (counterEventGenerator) {
                this.triggerUserListener(holder.userListeners, holder.generator.generate(key, (CounterValue)event.getValue()));
            }
        }

        private void triggerUserListener(List<CounterListenerResponse<?>> userListeners, CounterEvent event) {
            if (userListeners.isEmpty() || event == null) {
                return;
            }
            CounterManagerNotificationManager.this.userListenerExecutor.execute(() -> userListeners.parallelStream().forEach(l -> l.onUpdate(event)));
        }
    }

    private static class CounterListenerResponse<T extends CounterListener>
    implements Handle<T>,
    CounterListener {
        private final T listener;
        private final Holder holder;

        private CounterListenerResponse(T listener, Holder holder) {
            this.listener = listener;
            this.holder = holder;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.holder.removeListener(this);
        }

        public void onUpdate(CounterEvent event) {
            try {
                this.listener.onUpdate(event);
            }
            catch (Throwable t) {
                log.warnf(t, "Exception while invoking listener %s", this.listener);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterListenerResponse that = (CounterListenerResponse)o;
            return this.listener.equals(that.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        /* synthetic */ CounterListenerResponse(CounterListener x0, Holder x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class Holder {
        private final CounterEventGenerator generator;
        private final List<CounterListenerResponse<?>> userListeners;
        private final TopologyChangeListener topologyChangeListener;

        private Holder(CounterEventGenerator generator, TopologyChangeListener topologyChangeListener) {
            this.generator = generator;
            this.topologyChangeListener = topologyChangeListener;
            this.userListeners = new CopyOnWriteArrayList();
        }

        <T extends CounterListener> Holder addListener(T userListener, ByRef<Handle<T>> handleByRef) {
            CounterListenerResponse handle = new CounterListenerResponse(userListener, this, null);
            this.userListeners.add(handle);
            handleByRef.set(handle);
            return this;
        }

        <T extends CounterListener> void removeListener(CounterListenerResponse<T> userListener) {
            this.userListeners.remove(userListener);
        }

        TopologyChangeListener getTopologyChangeListener() {
            return this.topologyChangeListener;
        }
    }
}

