/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.AbstractCompatRemoteQueryManager;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ProtobufEntityNameResolver;
import org.infinispan.query.remote.impl.util.LazyRef;

class ProtostreamCompatRemoteQueryManager
extends AbstractCompatRemoteQueryManager {
    private LazyRef<Transcoder> transcoder = new LazyRef<Transcoder>(() -> this.encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON));

    ProtostreamCompatRemoteQueryManager(ComponentRegistry cr) {
        super(cr);
    }

    @Override
    EntityNameResolver createEntityNamesResolver(ComponentRegistry cr) {
        return new ProtobufEntityNameResolver(this.ctx);
    }

    @Override
    CompatibilityReflectionMatcher createMatcher(EntityNameResolver entityNameResolver, SerializationContext ctx, SearchIntegrator searchFactory) {
        if (searchFactory == null) {
            return new CompatibilityReflectionMatcher(entityNameResolver, ctx);
        }
        return new CompatibilityReflectionMatcher(entityNameResolver, ctx, searchFactory);
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest) {
        try {
            return (QueryRequest)ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.ctx, (byte[])queryRequest, (int)0, (int)queryRequest.length, QueryRequest.class);
        }
        catch (IOException e) {
            throw new CacheException();
        }
    }

    @Override
    public List<Object> encodeQueryResults(List<Object> results) {
        return results.stream().map(o -> this.transcoder.get().transcode(o, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON)).collect(Collectors.toList());
    }

    @Override
    public byte[] encodeQueryResponse(QueryResponse queryResponse) {
        try {
            return ProtobufUtil.toByteArray((ImmutableSerializationContext)this.ctx, (Object)queryResponse);
        }
        catch (IOException e) {
            throw new CacheException();
        }
    }
}

