/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

enum JGroupsSchema {
    INFINISPAN_SERVER_JGROUPS_7_0("infinispan:server:jgroups", 7, 0),
    INFINISPAN_SERVER_JGROUPS_8_0("infinispan:server:jgroups", 8, 0),
    INFINISPAN_SERVER_JGROUPS_9_0("infinispan:server:jgroups", 9, 0),
    INFINISPAN_SERVER_JGROUPS_9_2("infinispan:server:jgroups", 9, 2);

    public static final JGroupsSchema CURRENT;
    private static final String URN_PATTERN = "urn:%s:%d.%d";
    private final String domain;
    private final int major;
    private final int minor;

    private JGroupsSchema(String domain, int major, int minor) {
        this.domain = domain;
        this.major = major;
        this.minor = minor;
    }

    public boolean since(JGroupsSchema ... schemas) {
        for (JGroupsSchema schema : schemas) {
            if (!this.domain.equals(schema.domain) || this.major <= schema.major && (this.major != schema.major || this.minor < schema.minor)) continue;
            return true;
        }
        return false;
    }

    public String getNamespaceUri() {
        return this.format(URN_PATTERN);
    }

    String format(String pattern) {
        return String.format(pattern, this.domain, this.major, this.minor);
    }

    static {
        CURRENT = INFINISPAN_SERVER_JGROUPS_9_0;
    }
}

