/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TextObjectTranscoder
implements Transcoder {
    protected static final Log logger = (Log)LogFactory.getLog(TextObjectTranscoder.class, Log.class);
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();

    public TextObjectTranscoder() {
        supportedTypes.add(MediaType.TEXT_PLAIN);
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            if (content instanceof byte[]) {
                return content;
            }
            return content.toString();
        }
        return content;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }
}

