/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.mediatypes.impl.JSONOutputPrinter;
import org.infinispan.util.logging.LogFactory;

public class XMLObjectTranscoder
implements Transcoder {
    protected static final Log logger = (Log)LogFactory.getLog(JSONOutputPrinter.class, Log.class);
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();

    public XMLObjectTranscoder() {
        supportedTypes.add(MediaType.APPLICATION_XML);
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            try {
                return XStreamHolder.XStream.toXML(content).getBytes("UTF-8");
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            if (content instanceof byte[]) {
                return content;
            }
            return XStreamHolder.XStream.fromXML((Reader)new StringReader((String)content));
        }
        return null;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }

    private static class XStreamHolder {
        static final XStream XStream = new XStream();

        private XStreamHolder() {
        }
    }
}

