/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import org.infinispan.protostream.AnnotationParserException;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.impl.parser.AnnotationTokens;

final class AnnotationLexer {
    AnnotationTokens token;
    long pos;
    long lastPos;
    String name;
    private char[] sbuf = new char[128];
    private int sp;
    private final char[] buf;
    private final int buflen;
    private int bp = -1;
    private char ch = '\u0000';
    private int line = 1;
    private int col = 0;
    private boolean leadingWhitespace = true;
    private boolean expectDocNoise;

    AnnotationLexer(char[] input, boolean expectDocNoise) {
        this.expectDocNoise = expectDocNoise;
        this.buf = input;
        this.buflen = input.length;
        this.scanNextChar();
        this.skipDocNoise();
    }

    public void skipDocNoise() {
        if (this.token == AnnotationTokens.AT || this.token == AnnotationTokens.EOF) {
            return;
        }
        this.sp = 0;
        block8: do {
            switch (this.ch) {
                case '\t': 
                case ' ': {
                    this.scanNextChar();
                    break;
                }
                case '\f': {
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    break;
                }
                case '\r': {
                    ++this.line;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    if (this.ch != '\n') continue block8;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    break;
                }
                case '\n': {
                    ++this.line;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    break;
                }
                case '@': {
                    if (!this.leadingWhitespace) {
                        throw new AnnotationParserException(String.format("Error: %d,%d: Annotations must start on an empty line", this.line, this.col));
                    }
                }
                case '\u0000': {
                    this.nextToken();
                    return;
                }
                default: {
                    if (this.expectDocNoise) {
                        this.scanNextChar();
                        break;
                    }
                    throw new AnnotationParserException(String.format("Error: %d,%d: Unexpected character: %c", this.line, this.col, Character.valueOf(this.ch)));
                }
            }
        } while (this.bp != this.buflen);
        this.token = AnnotationTokens.EOF;
    }

    private void scanNextChar() {
        if (this.ch != '\u0000' && !Character.isWhitespace(this.ch)) {
            this.leadingWhitespace = false;
        }
        ++this.bp;
        if (this.bp == this.buflen) {
            this.ch = '\u0000';
        } else {
            this.ch = this.buf[this.bp];
            ++this.col;
        }
    }

    private void putChar(char c) {
        if (this.sp == this.sbuf.length) {
            char[] newSbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newSbuf, 0, this.sbuf.length);
            this.sbuf = newSbuf;
        }
        this.sbuf[this.sp++] = c;
    }

    private void scanLiteralChar() {
        block12: {
            block11: {
                if (this.ch != '\\') break block11;
                this.scanNextChar();
                switch (this.ch) {
                    case 'b': {
                        this.putChar('\b');
                        this.scanNextChar();
                        break block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanNextChar();
                        break block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanNextChar();
                        break block12;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanNextChar();
                        break block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanNextChar();
                        break block12;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanNextChar();
                        break block12;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanNextChar();
                        break block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanNextChar();
                        break block12;
                    }
                    default: {
                        throw new AnnotationParserException(String.format("Error: %d,%d: illegal escape character: %c", this.line, this.col, Character.valueOf(this.ch)));
                    }
                }
            }
            if (this.bp != this.buflen) {
                this.putChar(this.ch);
                this.scanNextChar();
            }
        }
    }

    private void scanDecimal() {
        while (Character.digit(this.ch, 10) >= 0) {
            this.putChar(this.ch);
            this.scanNextChar();
        }
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanNextChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanNextChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanNextChar();
                } while ('0' <= this.ch && this.ch <= '9');
            } else {
                throw new AnnotationParserException(String.format("Error: %s: malformed floating point literal", AnnotationElement.positionToString(this.pos)));
            }
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.scanNextChar();
            this.token = AnnotationTokens.FLOAT_LITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.scanNextChar();
            }
            this.token = AnnotationTokens.DOUBLE_LITERAL;
        }
    }

    private void scanNumber() {
        while (Character.digit(this.ch, 10) >= 0) {
            this.putChar(this.ch);
            this.scanNextChar();
        }
        if (this.ch == '.') {
            this.putChar(this.ch);
            this.scanNextChar();
            this.scanDecimal();
        } else if (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D') {
            this.scanDecimal();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanNextChar();
            this.token = AnnotationTokens.LONG_LITERAL;
        } else {
            this.token = AnnotationTokens.INT_LITERAL;
        }
    }

    private void scanIdentifier() {
        do {
            this.putChar(this.ch);
            if (++this.bp == this.buflen) {
                this.ch = '\u0000';
                break;
            }
            this.ch = this.buf[this.bp];
            ++this.col;
        } while (this.ch == '_' || this.ch == '$' || this.ch >= '0' && this.ch <= '9' || this.ch >= 'A' && this.ch <= 'Z' || this.ch >= 'a' && this.ch <= 'z' || this.ch > '\u0080' && Character.isJavaIdentifierPart(this.ch));
        this.name = new String(this.sbuf, 0, this.sp);
        AnnotationTokens tok = AnnotationTokens.byName(this.name);
        this.token = tok == null ? AnnotationTokens.IDENTIFIER : tok;
    }

    public int mark() {
        return this.bp;
    }

    public String getText(int startIndex, int endIndex) {
        return new String(this.buf, startIndex, endIndex - startIndex);
    }

    public void nextToken() {
        this.lastPos = AnnotationElement.makePosition(this.line, this.col);
        this.sp = 0;
        block18: while (true) {
            this.pos = AnnotationElement.makePosition(this.line, this.col);
            switch (this.ch) {
                case ',': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.COMMA;
                    return;
                }
                case '(': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.LPAREN;
                    return;
                }
                case ')': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.RPAREN;
                    return;
                }
                case '{': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.LBRACE;
                    return;
                }
                case '}': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.RBRACE;
                    return;
                }
                case '@': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.AT;
                    return;
                }
                case '=': {
                    this.scanNextChar();
                    this.token = AnnotationTokens.EQ;
                    return;
                }
                case '.': {
                    this.scanNextChar();
                    if ('0' <= this.ch && this.ch <= '9') {
                        this.putChar('.');
                        this.scanDecimal();
                    } else {
                        this.token = AnnotationTokens.DOT;
                    }
                    return;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.scanIdentifier();
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber();
                    return;
                }
                case '\'': {
                    this.scanNextChar();
                    if (this.ch == '\'') {
                        throw new AnnotationParserException(String.format("Error: %s: empty character literal", AnnotationElement.positionToString(this.pos)));
                    }
                    if (this.ch == '\r' || this.ch == '\n') {
                        throw new AnnotationParserException(String.format("Error: %s: illegal line end in character literal", AnnotationElement.positionToString(this.pos)));
                    }
                    this.scanLiteralChar();
                    if (this.ch != '\'') {
                        throw new AnnotationParserException(String.format("Error: %s: unclosed character literal", AnnotationElement.positionToString(this.pos)));
                    }
                    this.scanNextChar();
                    this.token = AnnotationTokens.CHARACTER_LITERAL;
                    return;
                }
                case '\"': {
                    this.scanNextChar();
                    while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                        this.scanLiteralChar();
                    }
                    if (this.ch != '\"') {
                        throw new AnnotationParserException(String.format("Error: %s: unclosed string literal", AnnotationElement.positionToString(this.pos)));
                    }
                    this.token = AnnotationTokens.STRING_LITERAL;
                    this.scanNextChar();
                    return;
                }
                case '\t': 
                case ' ': {
                    this.scanNextChar();
                    continue block18;
                }
                case '\f': {
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    continue block18;
                }
                case '\r': {
                    ++this.line;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    if (this.ch != '\n') continue block18;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    continue block18;
                }
                case '\n': {
                    ++this.line;
                    this.col = 0;
                    this.leadingWhitespace = true;
                    this.scanNextChar();
                    continue block18;
                }
            }
            break;
        }
        if (this.ch == '\u0000' && this.bp == this.buflen) {
            this.token = AnnotationTokens.EOF;
        } else if (Character.isJavaIdentifierStart(this.ch)) {
            this.scanIdentifier();
        } else {
            throw new AnnotationParserException(String.format("Error: %s: illegal character: %c", AnnotationElement.positionToString(this.pos), Character.valueOf(this.ch)));
        }
    }
}

