/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.configuration.MultiTenantRouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.Router;
import org.infinispan.server.router.router.impl.hotrod.HotRodRouter;
import org.infinispan.server.router.router.impl.rest.RestRouter;

public class MultiTenantRouter {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private final MultiTenantRouterConfiguration routerConfiguration;
    private final Set<Router> routers = new HashSet<Router>();

    public MultiTenantRouter(MultiTenantRouterConfiguration routerConfiguration) {
        this.routerConfiguration = routerConfiguration;
        if (routerConfiguration.getHotRodRouterConfiguration() != null) {
            this.routers.add(new HotRodRouter(routerConfiguration.getHotRodRouterConfiguration()));
        }
        if (routerConfiguration.getRestRouterConfiguration() != null) {
            this.routers.add(new RestRouter(routerConfiguration.getRestRouterConfiguration()));
        }
    }

    public void start() {
        this.routers.forEach(r -> r.start(this.routerConfiguration.getRoutingTable()));
        logger.printOutRoutingTable(this.routerConfiguration.getRoutingTable());
    }

    public void stop() {
        this.routers.forEach(r -> r.stop());
    }

    public Optional<Router> getRouter(Router.Protocol protocol) {
        return this.routers.stream().filter(r -> r.getProtocol() == protocol).findFirst();
    }
}

