/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.controller.access.InVmAccess;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static boolean isInVmCall() {
        return SecurityActions.createInVmActions().isInVmCall();
    }

    private static InVmActions createInVmActions() {
        return WildFlySecurityManager.isChecking() ? InVmActions.PRIVILEGED : InVmActions.NON_PRIVILEGED;
    }

    private static interface InVmActions {
        public static final InVmActions NON_PRIVILEGED = new InVmActions(){

            @Override
            public boolean isInVmCall() {
                return InVmAccess.isInVmCall();
            }
        };
        public static final InVmActions PRIVILEGED = new InVmActions(){
            private final PrivilegedAction<Boolean> PRIVILEGED_ACTION = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return NON_PRIVILEGED.isInVmCall();
                }
            };

            @Override
            public boolean isInVmCall() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public boolean isInVmCall();
    }
}

