/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterWriter
extends OutputStream {
    private final Inflater inflater = new Inflater();
    private final OutputStream output;
    private final byte[] writeBuffer = new byte[1024];
    private int writePointer = 0;
    private final byte[] outputBuffer = new byte[this.writeBuffer.length * 2];

    public InflaterWriter(OutputStream output) {
        this.output = output;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeBuffer[this.writePointer] = (byte)(b & 0xFF);
        ++this.writePointer;
        if (this.writePointer == this.writeBuffer.length) {
            this.writePointer = 0;
            try {
                this.doWrite();
            }
            catch (DataFormatException e) {
                IOException ie = new IOException("Error decompressing data");
                ie.initCause(e);
                throw ie;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writePointer > 0) {
            this.inflater.setInput(this.writeBuffer, 0, this.writePointer);
            try {
                int n = this.inflater.inflate(this.outputBuffer);
                while (n > 0) {
                    this.output.write(this.outputBuffer, 0, n);
                    n = this.inflater.inflate(this.outputBuffer);
                }
                this.output.close();
            }
            catch (DataFormatException e) {
                IOException io = new IOException(e.getMessage());
                io.initCause(e);
                throw io;
            }
        }
    }

    private void doWrite() throws DataFormatException, IOException {
        this.inflater.setInput(this.writeBuffer);
        int n = this.inflater.inflate(this.outputBuffer);
        while (n > 0) {
            this.output.write(this.outputBuffer, 0, n);
            n = this.inflater.inflate(this.outputBuffer);
        }
    }
}

