/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;

public final class RemoteTransaction
extends AbstractTransaction {
    private final AtomicReference<State> stateRef;
    private final ConcurrentMap<Object, Object> resources = new ConcurrentHashMap<Object, Object>();
    private final AuthenticationContext authenticationContext;
    private final Object key = new Object();
    private final int timeout;
    static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    RemoteTransaction(AuthenticationContext authenticationContext, int timeout) {
        this.authenticationContext = authenticationContext;
        this.stateRef = new AtomicReference<Unlocated>(Unlocated.ACTIVE);
        this.timeout = timeout;
    }

    @Override
    public Object getResource(Object key) throws NullPointerException {
        Assert.checkNotNullParamWithNullPointerException("key", key);
        return this.resources.get(key);
    }

    @Override
    public void putResource(Object key, Object value) throws NullPointerException {
        Assert.checkNotNullParamWithNullPointerException("key", key);
        if (value == null) {
            this.resources.remove(key);
        } else {
            this.resources.put(key, value);
        }
    }

    @Override
    public Object putResourceIfAbsent(Object key, Object value) throws IllegalArgumentException {
        Assert.checkNotNullParamWithNullPointerException("key", key);
        return value == null ? this.resources.get(key) : this.resources.putIfAbsent(key, value);
    }

    @Override
    Object getKey() {
        return this.key;
    }

    @Override
    void suspend() {
        this.notifyAssociationListeners(false);
    }

    @Override
    void resume() {
        this.notifyAssociationListeners(true);
    }

    @Override
    void verifyAssociation() {
    }

    @Override
    public int getTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TransactionPermission.forName("getProviderInterface"));
        }
        return this.stateRef.get().getProviderInterface(providerInterfaceType);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        AtomicReference<State> stateRef = this.stateRef;
        stateRef.get().commit(stateRef);
    }

    @Override
    void commitAndDissociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this.commit();
        }
        finally {
            this.suspend();
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        AtomicReference<State> stateRef = this.stateRef;
        stateRef.get().rollback(stateRef);
    }

    @Override
    void rollbackAndDissociate() throws IllegalStateException, SystemException {
        try {
            this.rollback();
        }
        finally {
            this.suspend();
        }
    }

    @Override
    boolean importBacking() {
        return false;
    }

    @Override
    void unimportBacking() {
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        AtomicReference<State> stateRef = this.stateRef;
        stateRef.get().setRollbackOnly(stateRef);
    }

    @Override
    public int getStatus() {
        return this.stateRef.get().getStatus();
    }

    @Override
    public boolean enlistResource(XAResource xaRes) {
        Assert.checkNotNullParam("xaRes", xaRes);
        return false;
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) {
        Assert.checkNotNullParam("xaRes", xaRes);
        return false;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam("sync", sync);
        this.stateRef.get().registerSynchronization(new AbstractTransaction.AssociatingSynchronization(this, sync));
    }

    @Override
    void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        Assert.checkNotNullParam("sync", sync);
        this.stateRef.get().registerInterposedSynchronization(new AbstractTransaction.AssociatingSynchronization(this, sync));
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return String.format("Remote transaction %s", this.stateRef.get());
    }

    public URI getLocation() {
        return this.stateRef.get().getLocation();
    }

    public void setLocation(URI location) throws IllegalArgumentException, IllegalStateException, SystemException {
        SSLContext sslContext;
        Assert.checkNotNullParam("location", location);
        RemoteTransactionContext context = RemoteTransactionContext.getInstancePrivate();
        RemoteTransactionProvider provider = context.getProvider(location);
        if (provider == null) {
            throw Log.log.noProviderForUri(location);
        }
        AuthenticationContextConfigurationClient client = CLIENT;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(location, this.authenticationContext, -1, "jta", "jboss");
        try {
            sslContext = client.getSSLContext(location, this.authenticationContext, "jta", "jboss");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        SimpleTransactionControl control = provider.getPeerHandle(location, sslContext, authenticationConfiguration).begin(this.getEstimatedRemainingTime());
        try {
            this.stateRef.get().join(this.stateRef, location, control);
        }
        catch (Throwable t) {
            try {
                control.rollback();
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
    }

    public boolean tryClearLocation() {
        return this.stateRef.get().tryToDisassociate(this.stateRef);
    }

    static final class InactiveState
    extends State {
        private final int status;
        static final InactiveState ROLLED_BACK = new InactiveState(4);
        static final InactiveState COMMITTED = new InactiveState(3);
        static final InactiveState UNKNOWN = new InactiveState(5);
        static final InactiveState COMMITTING = new InactiveState(8);
        static final InactiveState ROLLING_BACK = new InactiveState(9);

        private InactiveState(int status) {
            this.status = status;
        }

        @Override
        void join(AtomicReference<State> stateRef, URI location, SimpleTransactionControl control) throws IllegalStateException {
            throw Log.log.notActive();
        }

        @Override
        void commit(AtomicReference<State> stateRef) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void rollback(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void setRollbackOnly(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            if (this.status != 9) {
                throw Log.log.notActive();
            }
        }

        @Override
        int getStatus() {
            return this.status;
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
            throw Log.log.notActive();
        }
    }

    static final class RollbackOnly
    extends Located {
        RollbackOnly(URI location, SimpleTransactionControl control) {
            super(location, control);
        }

        @Override
        void commit(AtomicReference<State> stateRef) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            this.rollback(stateRef);
            throw Log.log.rollbackOnlyRollback();
        }

        @Override
        void setRollbackOnly(AtomicReference<State> stateRef) {
        }

        @Override
        int getStatus() {
            return 1;
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.markedRollbackOnly();
        }
    }

    static final class Active
    extends Located {
        Active(URI location, SimpleTransactionControl control) {
            super(location, control);
        }

        @Override
        void commit(AtomicReference<State> stateRef) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            if (!stateRef.compareAndSet(this, InactiveState.COMMITTING)) {
                stateRef.get().commit(stateRef);
                return;
            }
            try {
                this.control.commit();
            }
            catch (SecurityException e) {
                stateRef.set(this);
                throw e;
            }
            catch (HeuristicRollbackException | RollbackException e) {
                stateRef.set(InactiveState.ROLLED_BACK);
                throw e;
            }
            catch (Throwable t) {
                stateRef.set(InactiveState.UNKNOWN);
                throw t;
            }
            stateRef.set(InactiveState.COMMITTED);
        }

        @Override
        int getStatus() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setRollbackOnly(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            AtomicReference<State> atomicReference = stateRef;
            synchronized (atomicReference) {
                RollbackOnly newState = new RollbackOnly(this.location, this.control);
                if (!stateRef.compareAndSet(this, newState)) {
                    stateRef.get().setRollbackOnly(stateRef);
                }
                this.control.setRollbackOnly();
            }
        }

        @Override
        boolean tryToDisassociate(AtomicReference<State> stateRef) throws IllegalStateException {
            return !this.multipleJoins && (stateRef.compareAndSet(this, Unlocated.ACTIVE) || stateRef.get().tryToDisassociate(stateRef));
        }
    }

    static abstract class Located
    extends Unresolved {
        final URI location;
        final SimpleTransactionControl control;
        volatile boolean multipleJoins = false;

        Located(URI location, SimpleTransactionControl control) {
            this.location = location;
            this.control = control;
        }

        @Override
        void join(AtomicReference<State> stateRef, URI location, SimpleTransactionControl control) throws IllegalStateException {
            if (!this.location.equals(location)) {
                throw Log.log.locationAlreadyInitialized(location, this.location);
            }
            this.multipleJoins = true;
        }

        @Override
        void rollback(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            if (!stateRef.compareAndSet(this, InactiveState.ROLLING_BACK)) {
                stateRef.get().rollback(stateRef);
                return;
            }
            try {
                this.control.rollback();
            }
            catch (SecurityException e) {
                stateRef.set(this);
                throw e;
            }
            catch (Throwable t) {
                stateRef.set(InactiveState.UNKNOWN);
                throw t;
            }
            stateRef.set(InactiveState.ROLLED_BACK);
        }

        @Override
        <T> T getProviderInterface(Class<T> providerInterfaceType) {
            return this.control.getProviderInterface(providerInterfaceType);
        }

        @Override
        URI getLocation() {
            return this.location;
        }
    }

    static final class Unlocated
    extends Unresolved {
        private final int status;
        static final Unlocated ACTIVE = new Unlocated(0);
        static final Unlocated ROLLBACK_ONLY = new Unlocated(1);

        Unlocated(int status) {
            this.status = status;
        }

        @Override
        void join(AtomicReference<State> stateRef, URI location, SimpleTransactionControl control) throws IllegalStateException {
            Located newState;
            switch (this.status) {
                case 0: {
                    newState = new Active(location, control);
                    break;
                }
                case 1: {
                    newState = new RollbackOnly(location, control);
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase(this.status);
                }
            }
            if (stateRef.compareAndSet(this, newState)) {
                return;
            }
            stateRef.get().join(stateRef, location, control);
        }

        @Override
        void commit(AtomicReference<State> stateRef) {
            stateRef.set(InactiveState.COMMITTED);
        }

        @Override
        void rollback(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            stateRef.set(InactiveState.ROLLED_BACK);
        }

        @Override
        void setRollbackOnly(AtomicReference<State> stateRef) throws IllegalStateException, SystemException {
            stateRef.set(ROLLBACK_ONLY);
        }

        @Override
        int getStatus() {
            return this.status;
        }

        @Override
        boolean tryToDisassociate(AtomicReference<State> stateRef) {
            return true;
        }
    }

    static abstract class Unresolved
    extends State {
        Unresolved() {
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.registerSynchRemoteTransaction();
        }

        @Override
        void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
            throw Log.log.registerSynchRemoteTransaction();
        }
    }

    static abstract class State {
        State() {
        }

        abstract void join(AtomicReference<State> var1, URI var2, SimpleTransactionControl var3) throws IllegalStateException;

        boolean tryToDisassociate(AtomicReference<State> stateRef) {
            return false;
        }

        abstract void commit(AtomicReference<State> var1) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

        abstract void rollback(AtomicReference<State> var1) throws IllegalStateException, SystemException;

        abstract void setRollbackOnly(AtomicReference<State> var1) throws IllegalStateException, SystemException;

        abstract int getStatus();

        abstract void registerSynchronization(Synchronization var1) throws RollbackException, IllegalStateException, SystemException;

        abstract void registerInterposedSynchronization(Synchronization var1) throws IllegalStateException;

        <T> T getProviderInterface(Class<T> providerInterfaceType) {
            return null;
        }

        URI getLocation() {
            return null;
        }
    }
}

