/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.dmr.ModelNode;

public class OperationNameCompleter
extends DefaultCompleter {
    public OperationNameCompleter(final OperationRequestAddress address) {
        super(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode response;
                ModelNode req = new ModelNode();
                ModelNode addrNode = req.get("address");
                for (OperationRequestAddress.Node node : address) {
                    addrNode.add(node.getType(), node.getName());
                }
                req.get("operation").set("read-operation-names");
                if (ctx.getConfig().isAccessControl()) {
                    req.get("access-control").set(true);
                }
                try {
                    response = ctx.getModelControllerClient().execute(req);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return Collections.emptyList();
                }
                List<ModelNode> list = result.asList();
                ArrayList<String> names = new ArrayList<String>(list.size());
                for (ModelNode node : list) {
                    names.add(node.asString());
                }
                return names;
            }
        });
    }
}

