/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.groups;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.validation.GroupDefinitionException;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.Sequence;

public interface ValidationOrder {
    public static final ValidationOrder DEFAULT_SEQUENCE = new DefaultValidationOrder();

    public Iterator<Group> getGroupIterator();

    public Iterator<Sequence> getSequenceIterator();

    public void assertDefaultGroupSequenceIsExpandable(List<Class<?>> var1) throws GroupDefinitionException;

    public static class DefaultValidationOrder
    implements ValidationOrder {
        private final List<Sequence> defaultSequences = Collections.singletonList(Sequence.DEFAULT);

        private DefaultValidationOrder() {
        }

        @Override
        public Iterator<Group> getGroupIterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public Iterator<Sequence> getSequenceIterator() {
            return this.defaultSequences.iterator();
        }

        @Override
        public void assertDefaultGroupSequenceIsExpandable(List<Class<?>> defaultGroupSequence) throws GroupDefinitionException {
        }
    }
}

