/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch2SchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchMappingBuilder;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.FieldDataType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.NormsType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class Elasticsearch50SchemaTranslator
extends Elasticsearch2SchemaTranslator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    @Override
    public boolean isTextDataType(PartialDocumentFieldMetadata fieldMetadata) {
        FieldHelper.ExtendedFieldType fieldType;
        DataType stringDataType = this.getStringType(fieldMetadata.getPath().getAbsoluteName(), fieldMetadata.getIndex(), fieldMetadata.getAnalyzerReference());
        return DataType.TEXT.equals((Object)stringDataType) && (FieldHelper.ExtendedFieldType.STRING.equals((Object)(fieldType = FieldHelper.getType(fieldMetadata))) || FieldHelper.ExtendedFieldType.UNKNOWN.equals((Object)fieldType));
    }

    @Override
    protected PropertyMapping generateTenantIdProperty() {
        PropertyMapping tenantId = new PropertyMapping();
        tenantId.setType(DataType.KEYWORD);
        tenantId.setIndex(IndexType.TRUE);
        return tenantId;
    }

    @Override
    protected void addSubfieldIndexOptions(PropertyMapping fieldMapping, FacetMetadata facetMetadata) {
        fieldMapping.setIndex(IndexType.TRUE);
    }

    @Override
    protected void addIndexOptions(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, PropertyMetadata sourceProperty, String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        propertyMapping.setIndex(index.isIndexed() ? IndexType.TRUE : IndexType.FALSE);
        DataType type = propertyMapping.getType();
        if (FieldHelper.isSortableField(mappingBuilder.getMetadata(), sourceProperty, propertyPath)) {
            if (DataType.TEXT.equals((Object)type)) {
                propertyMapping.setFieldData(FieldDataType.TRUE);
            } else if (!index.isIndexed()) {
                propertyMapping.setDocValues(true);
            }
        }
        this.addAnalyzerOptions(propertyMapping, mappingBuilder, settingsBuilder, propertyPath, index, analyzerReference);
        if (DataType.TEXT.equals((Object)type) || DataType.KEYWORD.equals((Object)type)) {
            propertyMapping.setNorms(index.omitNorms() ? NormsType.FALSE : NormsType.TRUE);
        }
    }

    protected void addAnalyzerOptions(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        DataType type = propertyMapping.getType();
        if (DataType.TEXT.equals((Object)type) && analyzerReference != null) {
            if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
                log.analyzerIsNotElasticsearch(mappingBuilder.getTypeIdentifier(), propertyPath, analyzerReference);
            } else {
                ElasticsearchAnalyzerReference elasticsearchReference = (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
                String analyzerName = settingsBuilder.register(elasticsearchReference, propertyPath);
                propertyMapping.setAnalyzer(analyzerName);
            }
        }
    }

    @Override
    protected DataType getStringType(String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        return index.isAnalyzed() ? DataType.TEXT : DataType.KEYWORD;
    }
}

