/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.memcached.MemcachedDecoder;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.Log;

public class MemcachedServer
extends AbstractProtocolServer<MemcachedServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    protected ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private AdvancedCache<String, byte[]> memcachedCache;

    public MemcachedServer() {
        super("Memcached");
    }

    protected void startInternal(MemcachedServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        ExpirationConfiguration expConfig;
        if (cacheManager.getCacheConfiguration(configuration.defaultCacheName()) == null) {
            cacheManager.defineConfiguration(configuration.defaultCacheName(), new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).build());
        }
        if ((expConfig = cacheManager.getCacheConfiguration(configuration.defaultCacheName()).expiration()).lifespan() >= 0L || expConfig.maxIdle() >= 0L) {
            throw log.invalidExpiration(configuration.defaultCacheName());
        }
        Cache cache = cacheManager.getCache(configuration.defaultCacheName());
        this.memcachedCache = cache.getAdvancedCache();
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return new MemcachedDecoder(this.memcachedCache, this.scheduler, this.transport, arg_0 -> ((MemcachedServer)this).isCacheIgnored(arg_0));
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers((NettyInitializer)new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), this.getDecoder()));
    }

    public void stop() {
        super.stop();
        this.scheduler.shutdown();
    }
}

