/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.datasource;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.ds.DsSecurityImpl;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.metadata.ds.DsPoolImpl;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DataSourceDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    public static final String USER_PROP = "user";
    public static final String URL_PROP = "url";
    public static final String UPPERCASE_URL_PROP = "URL";
    public static final String TRANSACTIONAL_PROP = "transactional";
    public static final String SERVER_NAME_PROP = "serverName";
    public static final String PORT_NUMBER_PROP = "portNumber";
    public static final String PASSWORD_PROP = "password";
    public static final String MIN_POOL_SIZE_PROP = "minPoolSize";
    public static final String MAX_STATEMENTS_PROP = "maxStatements";
    public static final String MAX_IDLE_TIME_PROP = "maxIdleTime";
    public static final String LOGIN_TIMEOUT_PROP = "loginTimeout";
    public static final String ISOLATION_LEVEL_PROP = "isolationLevel";
    public static final String INITIAL_POOL_SIZE_PROP = "initialPoolSize";
    public static final String DESCRIPTION_PROP = "description";
    public static final String DATABASE_NAME_PROP = "databaseName";
    public static final String MAX_POOL_SIZE_PROP = "maxPoolSize";
    private String className;
    private String description;
    private String url;
    private String databaseName;
    private String serverName;
    private int portNumber = -1;
    private int loginTimeout = -1;
    private int isolationLevel = -1;
    private boolean transactional = true;
    private int initialPoolSize = -1;
    private int maxIdleTime = -1;
    private int maxPoolSize = -1;
    private int maxStatements = -1;
    private int minPoolSize = -1;
    private String user;
    private String password;

    public DataSourceDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        String poolName = this.uniqueName(context, this.jndiName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)this.jndiName);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        try {
            Class clazz = module.getClassLoader().loadClass(this.className);
            this.clearUnknownProperties(reflectionIndex, clazz, this.properties);
            this.populateProperties(reflectionIndex, clazz, this.properties);
            DsSecurityImpl dsSecurity = new DsSecurityImpl(this.user, this.password, null, false, null, null);
            if (XADataSource.class.isAssignableFrom(clazz) && this.transactional) {
                DsXaPoolImpl xaPool = new DsXaPoolImpl(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : Integer.valueOf(this.minPoolSize), this.initialPoolSize < 0 ? Defaults.INITIAL_POOL_SIZE : Integer.valueOf(this.initialPoolSize), this.maxPoolSize < 1 ? Defaults.MAX_POOL_SIZE : Integer.valueOf(this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL, Boolean.FALSE, null, Defaults.FAIR, null);
                ModifiableXaDataSource dataSource = new ModifiableXaDataSource(this.transactionIsolation(), null, dsSecurity, null, null, null, null, null, null, poolName, true, this.jndiName, false, false, Defaults.CONNECTABLE, Defaults.TRACKING, Defaults.MCP, Defaults.ENLISTMENT_TRACE, this.properties, this.className, null, null, (DsXaPool)xaPool, null);
                XaDataSourceService xds = new XaDataSourceService(bindInfo.getBinderServiceName().getCanonicalName(), bindInfo, (ClassLoader)module.getClassLoader());
                xds.getDataSourceConfigInjector().inject((Object)dataSource);
                this.startDataSource(xds, bindInfo, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
            } else {
                DsPoolImpl commonPool = new DsPoolImpl(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : Integer.valueOf(this.minPoolSize), this.initialPoolSize < 0 ? Defaults.INITIAL_POOL_SIZE : Integer.valueOf(this.initialPoolSize), this.maxPoolSize < 1 ? Defaults.MAX_POOL_SIZE : Integer.valueOf(this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Boolean.FALSE, null, Defaults.FAIR, null);
                ModifiableDataSource dataSource = new ModifiableDataSource(this.url, null, this.className, null, this.transactionIsolation(), this.properties, null, dsSecurity, null, null, null, null, null, false, poolName, true, this.jndiName, Defaults.SPY, Defaults.USE_CCM, this.transactional, Defaults.CONNECTABLE, Defaults.TRACKING, Defaults.MCP, Defaults.ENLISTMENT_TRACE, (DsPool)commonPool);
                LocalDataSourceService ds = new LocalDataSourceService(bindInfo.getBinderServiceName().getCanonicalName(), bindInfo, (ClassLoader)module.getClassLoader());
                ds.getDataSourceConfigInjector().inject((Object)dataSource);
                this.startDataSource(ds, bindInfo, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void clearUnknownProperties(DeploymentReflectionIndex reflectionIndex, Class<?> dataSourceClass, Map<String, String> props) {
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Class<?> paramType;
            Map.Entry<String, String> entry = it.next();
            String value = entry.getKey();
            if (value == null || "".equals(value)) {
                it.remove();
                continue;
            }
            StringBuilder builder = new StringBuilder("set").append(entry.getKey());
            builder.setCharAt(3, Character.toUpperCase(entry.getKey().charAt(0)));
            String methodName = builder.toString();
            MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{paramType = value.getClass()});
            Method setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)reflectionIndex, dataSourceClass, (MethodIdentifier)methodIdentifier);
            if (setterMethod != null) continue;
            it.remove();
            ConnectorLogger.DS_DEPLOYER_LOGGER.methodNotFoundOnDataSource(methodName, dataSourceClass);
        }
    }

    private String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder name = new StringBuilder();
        name.append(context.getApplicationName() + "_");
        name.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            name.append(context.getComponentName() + "_");
        }
        name.append(jndiName);
        return name.toString();
    }

    private void startDataSource(AbstractDataSourceService dataSourceService, ContextNames.BindInfo bindInfo, EEModuleDescription moduleDescription, InjectionSource.ResolutionContext context, ServiceTarget serviceTarget, ServiceBuilder valueSourceServiceBuilder, Injector<ManagedReferenceFactory> injector) {
        ServiceName dataSourceServiceName = AbstractDataSourceService.getServiceName(bindInfo);
        ServiceBuilder dataSourceServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService), dataSourceService.getExecutorServiceInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, dataSourceService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, dataSourceService.getRaRepositoryInjector()).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"})).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(NamingService.SERVICE_NAME);
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        if (DataSourceDefinitionInjectionSource.this.isTransactional()) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(DataSourceDefinitionInjectionSource.this.jndiName);
                            break;
                        }
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundNonJTADataSource(DataSourceDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        if (DataSourceDefinitionInjectionSource.this.isTransactional()) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(DataSourceDefinitionInjectionSource.this.jndiName);
                            break;
                        }
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unBoundNonJTADataSource(DataSourceDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", DataSourceDefinitionInjectionSource.this.jndiName);
                    }
                }
            }
        });
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        valueSourceServiceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
    }

    private TransactionIsolation transactionIsolation() {
        switch (this.isolationLevel) {
            case 0: {
                return TransactionIsolation.TRANSACTION_NONE;
            }
            case 2: {
                return TransactionIsolation.TRANSACTION_READ_COMMITTED;
            }
            case 1: {
                return TransactionIsolation.TRANSACTION_READ_UNCOMMITTED;
            }
            case 4: {
                return TransactionIsolation.TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TransactionIsolation.TRANSACTION_SERIALIZABLE;
            }
        }
        return TransactionIsolation.TRANSACTION_READ_COMMITTED;
    }

    private void populateProperties(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> dataSourceClass, Map<String, String> properties) {
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, DESCRIPTION_PROP, this.description);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, URL_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, UPPERCASE_URL_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, DATABASE_NAME_PROP, this.databaseName);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, SERVER_NAME_PROP, this.serverName);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, PORT_NUMBER_PROP, this.portNumber);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, LOGIN_TIMEOUT_PROP, this.loginTimeout);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, ISOLATION_LEVEL_PROP, this.isolationLevel);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, TRANSACTIONAL_PROP, this.transactional);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, INITIAL_POOL_SIZE_PROP, this.initialPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_IDLE_TIME_PROP, this.maxIdleTime);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_POOL_SIZE_PROP, this.maxPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_STATEMENTS_PROP, this.maxStatements);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MIN_POOL_SIZE_PROP, this.minPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, INITIAL_POOL_SIZE_PROP, this.minPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, USER_PROP, this.user);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, PASSWORD_PROP, this.password);
    }

    private void setProperty(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> dataSourceClass, Map<String, String> properties, String name, Object value) {
        if (value == null || "".equals(value)) {
            return;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return;
        }
        StringBuilder builder = new StringBuilder("set").append(name);
        builder.setCharAt(3, Character.toUpperCase(name.charAt(0)));
        String methodName = builder.toString();
        Class<?> paramType = value.getClass();
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{paramType});
        Method setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, dataSourceClass, (MethodIdentifier)methodIdentifier);
        if (setterMethod != null) {
            properties.put(name, value.toString());
        } else if (paramType == Integer.class) {
            methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{Integer.TYPE});
            setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, dataSourceClass, (MethodIdentifier)methodIdentifier);
            if (setterMethod != null) {
                properties.put(name, value.toString());
            }
        } else if (paramType == Boolean.class && (setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, dataSourceClass, (MethodIdentifier)(methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{Boolean.TYPE})))) != null) {
            properties.put(name, value.toString());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataSourceDefinitionInjectionSource that = (DataSourceDefinitionInjectionSource)((Object)o);
        if (this.initialPoolSize != that.initialPoolSize) {
            return false;
        }
        if (this.isolationLevel != that.isolationLevel) {
            return false;
        }
        if (this.loginTimeout != that.loginTimeout) {
            return false;
        }
        if (this.maxIdleTime != that.maxIdleTime) {
            return false;
        }
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.maxStatements != that.maxStatements) {
            return false;
        }
        if (this.minPoolSize != that.minPoolSize) {
            return false;
        }
        if (this.portNumber != that.portNumber) {
            return false;
        }
        if (this.transactional != that.transactional) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
        result = 31 * result + this.portNumber;
        result = 31 * result + this.loginTimeout;
        result = 31 * result + this.isolationLevel;
        result = 31 * result + (this.transactional ? 1 : 0);
        result = 31 * result + this.initialPoolSize;
        result = 31 * result + this.maxIdleTime;
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + this.maxStatements;
        result = 31 * result + this.minPoolSize;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }
}

