/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ProxyConfigurationWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public ProxyConfigurationWriteAttributeHandler(AttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
    }

    protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode conf = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                if (conf.hasDefined("proxy-list") && conf.hasDefined("proxies") || context.getProcessType().isServer() && conf.hasDefined("proxy-list")) {
                    throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.proxyListAttributeUsage());
                }
            }
        }, OperationContext.Stage.MODEL);
    }
}

