/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public abstract class CounterDecodeContext {
    private String counterName;
    private DecodeStep nextDecodeStep = this::decodeName;

    public String getCounterName() {
        return this.counterName;
    }

    public final boolean decode(ByteBuf buffer) {
        while (this.nextDecodeStep != null) {
            if (this.nextDecodeStep.decode(buffer)) {
                return false;
            }
            buffer.markReaderIndex();
            this.nextDecodeStep = this.nextStep();
        }
        return true;
    }

    abstract DecodeStep nextStep();

    final void logDecoded(String name, Object value) {
        if (this.trace()) {
            this.log().tracef("Decode '%s'='%s'", name, value);
        }
    }

    abstract boolean trace();

    abstract Log log();

    private boolean decodeName(ByteBuf buffer) {
        Optional<String> optName = ExtendedByteBuf.readMaybeString(buffer);
        optName.ifPresent(name -> {
            this.counterName = name;
            this.logDecoded("counter name", name);
        });
        return !optName.isPresent();
    }

    static interface DecodeStep {
        public boolean decode(ByteBuf var1);
    }
}

