/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CommandConfirmationHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ConcurrentUtil;
import org.jboss.logging.Logger;

public final class ChannelImpl
implements Channel {
    private static final Logger logger = Logger.getLogger(ChannelImpl.class);
    private volatile long id;
    private final AtomicInteger reconnectID = new AtomicInteger(0);
    private ChannelHandler handler;
    private Packet response;
    private final Queue<Packet> resendCache;
    private int firstStoredCommandID;
    private final AtomicInteger lastConfirmedCommandID = new AtomicInteger(-1);
    private volatile CoreRemotingConnection connection;
    private volatile boolean closed;
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final Condition failoverCondition = this.lock.newCondition();
    private final Object sendLock = new Object();
    private final Object sendBlockingLock = new Object();
    private boolean failingOver;
    private final int confWindowSize;
    private int receivedBytes;
    private CommandConfirmationHandler commandConfirmationHandler;
    private volatile boolean transferring;
    private final List<Interceptor> interceptors;

    public ChannelImpl(CoreRemotingConnection connection, long id, int confWindowSize, List<Interceptor> interceptors) {
        this.connection = connection;
        this.id = id;
        this.confWindowSize = confWindowSize;
        this.resendCache = confWindowSize != -1 ? new ConcurrentLinkedQueue<Packet>() : null;
        this.interceptors = interceptors;
    }

    @Override
    public int getReconnectID() {
        return this.reconnectID.get();
    }

    @Override
    public boolean supports(byte packetType) {
        return this.supports(packetType, this.connection.getClientVersion());
    }

    @Override
    public boolean supports(byte packetType, int version) {
        switch (packetType) {
            case 114: {
                return version >= 122;
            }
            case 12: {
                return version >= 124;
            }
            case 122: {
                return version >= 125;
            }
            case 124: {
                return version >= 125;
            }
            case -7: {
                return version >= 126;
            }
            case -8: {
                return version >= 126;
            }
            case -10: {
                return version >= 127;
            }
        }
        return true;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confWindowSize;
    }

    @Override
    public void returnBlocking() {
        this.returnBlocking(null);
    }

    @Override
    public void returnBlocking(Throwable cause) {
        this.lock.lock();
        try {
            this.response = new ActiveMQExceptionMessage((ActiveMQException)ActiveMQClientMessageBundle.BUNDLE.unblockingACall(cause));
            this.sendCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean sendAndFlush(Packet packet) {
        return this.send(packet, -1, true, false);
    }

    @Override
    public boolean send(Packet packet) {
        return this.send(packet, -1, false, false);
    }

    @Override
    public boolean send(Packet packet, int reconnectID) {
        return this.send(packet, reconnectID, false, false);
    }

    @Override
    public boolean sendBatched(Packet packet) {
        return this.send(packet, -1, false, true);
    }

    @Override
    public void setTransferring(boolean transferring) {
        this.transferring = transferring;
    }

    private void waitForFailOver(String timeoutMsg) {
        try {
            if (this.connection.getBlockingCallFailoverTimeout() < 0L) {
                while (this.failingOver) {
                    this.failoverCondition.await();
                }
            } else if (!ConcurrentUtil.await((Condition)this.failoverCondition, (long)this.connection.getBlockingCallFailoverTimeout())) {
                logger.debug((Object)timeoutMsg);
            }
        }
        catch (InterruptedException e) {
            throw new ActiveMQInterruptedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send(Packet packet, int reconnectID, boolean flush, boolean batch) {
        if (ChannelImpl.invokeInterceptors(packet, this.interceptors, this.connection) != null) {
            return false;
        }
        Object object = this.sendLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending packet nonblocking " + packet + " on channeID=" + this.id));
            }
            ActiveMQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                if (this.failingOver) {
                    this.waitForFailOver("timed-out waiting for fail-over condition on non-blocking send");
                }
                if (this.transferring) {
                    throw ActiveMQClientMessageBundle.BUNDLE.cannotSendPacketDuringFailover();
                }
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.addResendPacket(packet);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Writing buffer for channelID=" + this.id));
            }
            this.checkReconnectID(reconnectID);
            this.connection.getTransportConnection().write(buffer, flush, batch);
            return true;
        }
    }

    private void checkReconnectID(int reconnectID) {
        if (reconnectID >= 0 && reconnectID != this.reconnectID.get()) {
            throw ActiveMQClientMessageBundle.BUNDLE.packetTransmissionInterrupted();
        }
    }

    @Override
    public Packet sendBlocking(Packet packet, byte expectedPacket) throws ActiveMQException {
        return this.sendBlocking(packet, -1, expectedPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet sendBlocking(Packet packet, int reconnectID, byte expectedPacket) throws ActiveMQException {
        String interceptionResult = ChannelImpl.invokeInterceptors(packet, this.interceptors, this.connection);
        if (interceptionResult != null) {
            throw ActiveMQClientMessageBundle.BUNDLE.interceptorRejectedPacket(interceptionResult);
        }
        if (this.closed) {
            throw ActiveMQClientMessageBundle.BUNDLE.connectionDestroyed();
        }
        if (this.connection.getBlockingCallTimeout() == -1L) {
            throw new IllegalStateException("Cannot do a blocking call timeout on a server side connection");
        }
        Object object = this.sendBlockingLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            ActiveMQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                long now;
                if (this.failingOver) {
                    this.waitForFailOver("timed-out waiting for fail-over condition on blocking send");
                }
                this.response = null;
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.addResendPacket(packet);
                }
                this.checkReconnectID(reconnectID);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Sending blocking " + packet));
                }
                this.connection.getTransportConnection().write(buffer, false, false);
                long start = System.currentTimeMillis();
                for (long toWait = this.connection.getBlockingCallTimeout(); !this.closed && (this.response == null || this.response.getType() != 20 && this.response.getType() != expectedPacket) && toWait > 0L; toWait -= now - start) {
                    try {
                        this.sendCondition.await(toWait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new ActiveMQInterruptedException((Throwable)e);
                    }
                    if (this.response != null && this.response.getType() != 20 && this.response.getType() != expectedPacket) {
                        ActiveMQClientLogger.LOGGER.packetOutOfOrder(this.response, new Exception("trace"));
                    }
                    if (this.closed) break;
                    now = System.currentTimeMillis();
                    start = now;
                }
                if (this.response == null) {
                    throw ActiveMQClientMessageBundle.BUNDLE.timedOutSendingPacket(this.connection.getBlockingCallTimeout(), packet.getType());
                }
                if (this.response.getType() == 20) {
                    ActiveMQExceptionMessage mem = (ActiveMQExceptionMessage)this.response;
                    ActiveMQException e = mem.getException();
                    e.fillInStackTrace();
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.response;
        }
    }

    public static String invokeInterceptors(Packet packet, List<Interceptor> interceptors, RemotingConnection connection) {
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                try {
                    boolean callNext = interceptor.intercept(packet, connection);
                    if (logger.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Invocation of interceptor ").append(interceptor.getClass().getName()).append(" on ").append(packet).append(" returned ").append(callNext);
                        logger.debug((Object)msg.toString());
                    }
                    if (callNext) continue;
                    return interceptor.getClass().getName();
                }
                catch (Throwable e) {
                    ActiveMQClientLogger.LOGGER.errorCallingInterceptor(e, interceptor);
                }
            }
        }
        return null;
    }

    @Override
    public void setCommandConfirmationHandler(CommandConfirmationHandler handler) {
        if (this.confWindowSize < 0) {
            String msg = "You can't set confirmationHandler on a connection with confirmation-window-size < 0. Look at the documentation for more information.";
            throw new IllegalStateException("You can't set confirmationHandler on a connection with confirmation-window-size < 0. Look at the documentation for more information.");
        }
        this.commandConfirmationHandler = handler;
    }

    @Override
    public void setHandler(ChannelHandler handler) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting handler on " + this + " as " + handler));
        }
        this.handler = handler;
    }

    @Override
    public ChannelHandler getHandler() {
        return this.handler;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.connection.isDestroyed() && !this.connection.removeChannel(this.id)) {
            throw ActiveMQClientMessageBundle.BUNDLE.noChannelToClose(this.id);
        }
        if (this.failingOver) {
            this.unlock();
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferConnection(CoreRemotingConnection newConnection) {
        Object object = this.connection.getTransferLock();
        synchronized (object) {
            this.connection.removeChannel(this.id);
            CoreRemotingConnection rnewConnection = newConnection;
            rnewConnection.putChannel(this.id, this);
            this.connection = rnewConnection;
            this.transferring = true;
        }
    }

    @Override
    public void replayCommands(int otherLastConfirmedCommandID) {
        if (this.resendCache != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Replaying commands on channelID=" + this.id));
            }
            this.clearUpTo(otherLastConfirmedCommandID);
            for (Packet packet : this.resendCache) {
                this.doWrite(packet);
            }
        }
    }

    @Override
    public void lock() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("lock channel " + this));
        }
        this.lock.lock();
        this.reconnectID.incrementAndGet();
        this.failingOver = true;
        this.lock.unlock();
    }

    @Override
    public void unlock() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("unlock channel " + this));
        }
        this.lock.lock();
        this.failingOver = false;
        this.failoverCondition.signalAll();
        this.lock.unlock();
    }

    @Override
    public CoreRemotingConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void flushConfirmations() {
        if (this.resendCache != null && this.receivedBytes != 0) {
            this.receivedBytes = 0;
            PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID.get());
            confirmed.setChannelID(this.id);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ChannelImpl::flushConfirmation flushing confirmation " + confirmed));
            }
            this.doWrite(confirmed);
        }
    }

    @Override
    public void confirm(Packet packet) {
        if (this.resendCache != null && packet.isRequiresConfirmations()) {
            this.lastConfirmedCommandID.incrementAndGet();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ChannelImpl::confirming packet " + packet + " last commandID=" + this.lastConfirmedCommandID));
            }
            this.receivedBytes += packet.getPacketSize();
            if (this.receivedBytes >= this.confWindowSize) {
                this.receivedBytes = 0;
                PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID.get());
                confirmed.setChannelID(this.id);
                this.doWrite(confirmed);
            }
        }
    }

    @Override
    public void clearCommands() {
        if (this.resendCache != null) {
            this.lastConfirmedCommandID.set(-1);
            this.firstStoredCommandID = 0;
            this.resendCache.clear();
        }
    }

    @Override
    public void handlePacket(Packet packet) {
        if (packet.getType() == 22) {
            if (this.resendCache != null) {
                PacketsConfirmedMessage msg = (PacketsConfirmedMessage)packet;
                this.clearUpTo(msg.getCommandID());
            }
            if (!this.connection.isClient()) {
                this.handler.handlePacket(packet);
            }
            return;
        }
        if (packet.isResponse()) {
            this.confirm(packet);
            this.lock.lock();
            try {
                this.response = packet;
                this.sendCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.handler != null) {
            this.handler.handlePacket(packet);
        }
    }

    private void doWrite(Packet packet) {
        ActiveMQBuffer buffer = packet.encode(this.connection);
        this.connection.getTransportConnection().write(buffer, false, false);
    }

    private void addResendPacket(Packet packet) {
        this.resendCache.add(packet);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ChannelImpl::addResendPacket adding packet " + packet + " stored commandID=" + this.firstStoredCommandID + " possible commandIDr=" + (this.firstStoredCommandID + this.resendCache.size())));
        }
    }

    private void clearUpTo(int lastReceivedCommandID) {
        int numberToClear = 1 + lastReceivedCommandID - this.firstStoredCommandID;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ChannelImpl::clearUpTo lastReceived commandID=" + lastReceivedCommandID + " first commandID=" + this.firstStoredCommandID + " number to clear " + numberToClear));
        }
        for (int i = 0; i < numberToClear; ++i) {
            Packet packet = this.resendCache.poll();
            if (packet == null) {
                ActiveMQClientLogger.LOGGER.cannotFindPacketToClear(lastReceivedCommandID, this.firstStoredCommandID);
                this.firstStoredCommandID = lastReceivedCommandID + 1;
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ChannelImpl::clearUpTo confirming " + packet + " towards " + this.commandConfirmationHandler));
            }
            if (this.commandConfirmationHandler == null) continue;
            this.commandConfirmationHandler.commandConfirmed(packet);
        }
        this.firstStoredCommandID += numberToClear;
    }

    public String toString() {
        return "Channel[id=" + CHANNEL_ID.idToString(this.id) + ", handler=" + this.handler + "]";
    }

    public static enum CHANNEL_ID {
        PING(0L),
        SESSION(1L),
        REPLICATION(2L),
        CLUSTER(3L),
        USER(10L);

        public final long id;

        private CHANNEL_ID(long id) {
            this.id = id;
        }

        protected static String idToString(long code) {
            for (CHANNEL_ID channel : EnumSet.allOf(CHANNEL_ID.class)) {
                if (channel.id != code) continue;
                return channel.toString();
            }
            return Long.toString(code);
        }
    }
}

