/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.util.NetworkUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.channels.MulticastMessageChannel;

class MCMPAdvertiseTask
implements Runnable {
    public static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    private static final boolean linuxLike;
    private static final boolean windows;
    private volatile int seq = 0;
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final byte[] ssalt;
    private final MessageDigest md;
    private final InetSocketAddress address;
    private final ModClusterContainer container;
    private final MulticastMessageChannel channel;
    private static final String CRLF = "\r\n";
    private static final char[] TABLE;

    static void advertise(ModClusterContainer container, MCMPConfig.AdvertiseConfig config, XnioWorker worker) throws IOException {
        MulticastMessageChannel channel;
        InetAddress group = InetAddress.getByName(config.getAdvertiseAddress());
        InetSocketAddress bindAddress = group == null ? new InetSocketAddress(config.getAdvertisePort()) : new InetSocketAddress(group, config.getAdvertisePort());
        try {
            channel = worker.createUdpServer(bindAddress, null, OptionMap.EMPTY);
        }
        catch (IOException e) {
            if (group != null && (linuxLike || windows)) {
                UndertowLogger.ROOT_LOGGER.potentialCrossTalking(group, group instanceof Inet4Address ? "IPv4" : "IPv6", e.getLocalizedMessage());
                bindAddress = new InetSocketAddress(config.getAdvertisePort());
                channel = worker.createUdpServer(bindAddress, null, OptionMap.EMPTY);
            }
            throw e;
        }
        MCMPAdvertiseTask task = new MCMPAdvertiseTask(container, config, channel);
        channel.getIoThread().execute((Runnable)task);
        channel.getIoThread().executeAtInterval((Runnable)task, (long)config.getAdvertiseFrequency(), TimeUnit.MILLISECONDS);
    }

    MCMPAdvertiseTask(ModClusterContainer container, MCMPConfig.AdvertiseConfig config, MulticastMessageChannel channel) throws IOException {
        this.container = container;
        this.protocol = config.getProtocol();
        String host = config.getManagementSocketAddress().getHostString();
        int zoneIndex = host.indexOf("%");
        this.host = zoneIndex < 0 ? host : host.substring(0, zoneIndex);
        this.port = config.getManagementSocketAddress().getPort();
        this.path = config.getPath();
        this.channel = channel;
        InetAddress group = InetAddress.getByName(config.getAdvertiseGroup());
        this.address = new InetSocketAddress(group, config.getAdvertisePort());
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String securityKey = config.getSecurityKey();
        if (securityKey == null) {
            this.ssalt = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        } else {
            this.md.reset();
            this.digestString(this.md, securityKey);
            this.ssalt = this.md.digest();
        }
        UndertowLogger.ROOT_LOGGER.proxyAdvertisementsStarted(this.address.toString(), config.getAdvertiseFrequency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] digest;
            byte[] ssalt = this.ssalt;
            String server = this.container.getServerID();
            String date = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            String seq = "" + this.seq++;
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                this.md.update(ssalt);
                this.digestString(this.md, date);
                this.digestString(this.md, seq);
                this.digestString(this.md, server);
                digest = this.md.digest();
            }
            String digestString = MCMPAdvertiseTask.bytesToHexString(digest);
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.0 200 OK").append(CRLF).append("Date: ").append(date).append(CRLF).append("Sequence: ").append(seq).append(CRLF).append("Digest: ").append(digestString).append(CRLF).append("Server: ").append(server).append(CRLF).append("X-Manager-Address: ").append(NetworkUtils.formatPossibleIpv6Address(this.host)).append(":").append(this.port).append(CRLF).append("X-Manager-Url: ").append(this.path).append(CRLF).append("X-Manager-Protocol: ").append(this.protocol).append(CRLF).append("X-Manager-Host: ").append(this.host).append(CRLF);
            String payload = builder.toString();
            ByteBuffer byteBuffer = ByteBuffer.wrap(payload.getBytes(StandardCharsets.US_ASCII));
            UndertowLogger.ROOT_LOGGER.proxyAdvertiseMessagePayload(payload);
            this.channel.sendTo((SocketAddress)this.address, byteBuffer);
        }
        catch (Exception e) {
            UndertowLogger.ROOT_LOGGER.proxyAdvertiseCannotSendMessage(e, this.address);
        }
    }

    private void digestString(MessageDigest md, String securityKey) {
        byte[] buf = securityKey.getBytes(StandardCharsets.UTF_8);
        md.update(buf);
    }

    static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(TABLE[b >> 4 & 0xF]).append(TABLE[b & 0xF]);
        }
        return builder.toString();
    }

    static {
        String value = System.getProperty("os.name");
        linuxLike = value != null && (value.toLowerCase().startsWith("linux") || value.toLowerCase().startsWith("mac") || value.toLowerCase().startsWith("hp"));
        windows = value != null && value.toLowerCase().contains("win");
        TABLE = "0123456789abcdef".toCharArray();
    }
}

