/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HSEARCH")
public interface BaseHibernateSearchLogger
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=49, value="'%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity(String var1, @Cause InterruptedException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Illegal object retrieved from message")
    public void illegalObjectRetrievedFromMessage(@Cause Exception var1);

    @Message(id=114, value="Could not load resource: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @Message(id=140, value="Unknown Resolution: %1$s")
    public AssertionFailure unknownResolution(String var1);

    @Message(id=266, value="'%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported")
    public SearchException unsupportedFacetRangeParameter(String var1);

    @Message(id=324, value="The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.")
    public SearchException projectingFieldWithoutTwoWayFieldBridge(String var1, Class<?> var2);

    @Message(id=327, value="Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.")
    public SearchException unsupportedNullTokenType(@FormatWith(value=IndexedTypeIdentifierFormatter.class) IndexedTypeIdentifier var1, String var2, Class<?> var3);

    @Message(id=329, value="Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.")
    public SearchException invalidLuceneAnalyzerDefinitionProvider(String var1, @Cause Exception var2);
}

