/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class CounterMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CounterMetricsHandler INSTANCE = new CounterMetricsHandler();
    private static final int CACHE_CONTAINER_INDEX = 1;
    private static final int COUNTER_INDEX = 3;

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        ModelNode result = new ModelNode();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(1).getValue();
        String counterType = address.getElement(3).getKey();
        String counterName = address.getElement(3).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        if (controller != null) {
            Long value;
            DefaultCacheContainer cacheManager = (DefaultCacheContainer)controller.getValue();
            CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager);
            if ("strong-counter".equals(counterType)) {
                StrongCounter sc = counterManager.getStrongCounter(counterName);
                value = sc.sync().getValue();
            } else {
                WeakCounter wc = counterManager.getWeakCounter(counterName);
                value = wc.sync().getValue();
            }
            result.set(value.longValue());
        }
        context.getResult().set(result);
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (CounterMetrics metric : CounterMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static enum CounterMetrics {
        VALUE("value", ModelType.LONG);

        final AttributeDefinition definition;

        private CounterMetrics(String attributeName, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type).setRequired(true)).setStorageRuntime()).build();
        }

        public final String toString() {
            return this.definition.getName();
        }
    }
}

