/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Transaction;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.query.backend.QueryKnownClasses;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.logging.Log;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

final class SearchFactoryHandler {
    private static final Log log = (Log)LogFactory.getLog(SearchFactoryHandler.class, Log.class);
    private final SearchIntegrator searchFactory;
    private final QueryKnownClasses queryKnownClasses;
    private final TransactionHelper transactionHelper;
    private final Object cacheListener = new CacheListener();
    private final ReentrantLock mutating = new ReentrantLock();

    SearchFactoryHandler(SearchIntegrator searchFactory, QueryKnownClasses queryKnownClasses, TransactionHelper transactionHelper) {
        this.searchFactory = searchFactory;
        this.queryKnownClasses = queryKnownClasses;
        this.transactionHelper = transactionHelper;
    }

    boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            Boolean existingBoolean = this.queryKnownClasses.get(potentialNewType);
            if (existingBoolean != null) {
                return existingBoolean;
            }
            this.handleOnDemandRegistration(false, potentialNewType);
            Boolean isIndexable = this.queryKnownClasses.get(potentialNewType);
            return isIndexable != null ? isIndexable : false;
        }
        return false;
    }

    private void handleOnDemandRegistration(boolean allowUndeclared, Class<?> ... classes) {
        ArrayList reducedSet = new ArrayList(classes.length);
        for (Class<?> type : classes) {
            if (this.queryKnownClasses.containsKey(type)) continue;
            reducedSet.add(type);
        }
        if (!reducedSet.isEmpty()) {
            if (this.queryKnownClasses.isAutodetectEnabled()) {
                Class[] toAdd = reducedSet.toArray(new Class[reducedSet.size()]);
                this.updateSearchFactory(toAdd);
                for (Class c : toAdd) {
                    this.queryKnownClasses.put(c, this.hasIndex(c));
                }
            } else if (!allowUndeclared) {
                log.detectedUnknownIndexedEntities(this.queryKnownClasses.getCacheName(), ((Object)reducedSet).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchFactory(Class<?> ... classes) {
        this.mutating.lock();
        try {
            ArrayList reducedSet = new ArrayList(classes.length);
            for (Class<?> type : classes) {
                if (this.hasIndex(type)) continue;
                reducedSet.add(type);
            }
            if (reducedSet.isEmpty()) {
                return;
            }
            Class[] newtypes = reducedSet.toArray(new Class[reducedSet.size()]);
            Transaction tx = this.transactionHelper.suspendTxIfExists();
            try {
                this.searchFactory.addClasses(newtypes);
            }
            finally {
                this.transactionHelper.resume(tx);
            }
            for (Class type : newtypes) {
                if (!this.hasIndex(type)) continue;
                log.detectedUnknownIndexedEntity(this.queryKnownClasses.getCacheName(), type.getName());
            }
        }
        finally {
            this.mutating.unlock();
        }
    }

    boolean hasIndex(Class<?> c) {
        return this.searchFactory.getIndexBindings().get(c) != null;
    }

    private void handleClusterRegistryRegistration(Class<?> clazz) {
        if (this.hasIndex(clazz)) {
            return;
        }
        this.updateSearchFactory(clazz);
    }

    void enableClasses(Class[] classes) {
        this.handleOnDemandRegistration(true, classes);
    }

    Object getCacheListener() {
        return this.cacheListener;
    }

    @Listener
    final class CacheListener {
        CacheListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<KeyValuePair<String, Class>, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                SearchFactoryHandler.this.handleClusterRegistryRegistration((Class)((KeyValuePair)e.getKey()).getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<KeyValuePair<String, Class>, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                SearchFactoryHandler.this.handleClusterRegistryRegistration((Class)((KeyValuePair)e.getKey()).getValue());
            }
        }
    }
}

