/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.proxy.DefaultProxyInstantiator;
import org.jboss.weld.bean.proxy.ReflectionFactoryProxyInstantiator;
import org.jboss.weld.bean.proxy.UnsafeProxyInstantiator;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Reflections;

public interface ProxyInstantiator
extends Service {
    public <T> T newInstance(Class<T> var1) throws InstantiationException, IllegalAccessException;

    public <T> UnproxyableResolutionException validateNoargConstructor(Constructor<T> var1, Class<?> var2, Bean<?> var3) throws UnproxyableResolutionException;

    public boolean isUsingConstructor();

    public static class Factory {
        private static final List<String> IMPLEMENTATIONS = ImmutableList.of(new String[]{UnsafeProxyInstantiator.class.getName(), ReflectionFactoryProxyInstantiator.class.getName()});

        private Factory() {
        }

        public static ProxyInstantiator create(WeldConfiguration configuration) {
            ProxyInstantiator result = DefaultProxyInstantiator.INSTANCE;
            String instantiator = configuration.getStringProperty(ConfigurationKey.PROXY_INSTANTIATOR);
            if (!instantiator.isEmpty()) {
                if (!DefaultProxyInstantiator.class.getName().equals(instantiator)) {
                    try {
                        result = Factory.newInstance(instantiator);
                    }
                    catch (Exception e) {
                        throw new WeldException(e);
                    }
                }
            } else if (configuration.getBooleanProperty(ConfigurationKey.RELAXED_CONSTRUCTION).booleanValue() || configuration.getBooleanProperty(ConfigurationKey.PROXY_UNSAFE).booleanValue()) {
                for (String implementation : IMPLEMENTATIONS) {
                    try {
                        result = Factory.newInstance(implementation);
                        break;
                    }
                    catch (Exception e) {
                        BootstrapLogger.LOG.catchingDebug(e);
                    }
                    catch (LinkageError e) {
                        BootstrapLogger.LOG.catchingDebug(e);
                    }
                }
            }
            BootstrapLogger.LOG.debugv("Using instantiator: {0}", result.getClass().getName());
            return result;
        }

        private static ProxyInstantiator newInstance(String implementation) throws InstantiationException, IllegalAccessException {
            if (DefaultProxyInstantiator.class.getName().equals(implementation)) {
                return DefaultProxyInstantiator.INSTANCE;
            }
            Class clazz = Reflections.loadClass(implementation, new ClassLoaderResourceLoader(ProxyInstantiator.class.getClassLoader()));
            if (clazz == null) {
                throw new WeldException("Unable to load ProxyInstantiator implementation: " + implementation);
            }
            return (ProxyInstantiator)clazz.newInstance();
        }
    }
}

