/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.util.FieldPutter;

class RiverPutField
extends ObjectOutputStream.PutField {
    private final FieldPutter[] fields;
    private final String[] names;

    public RiverPutField(FieldPutter[] fields, String[] names) {
        this.fields = fields;
        this.names = names;
    }

    private FieldPutter find(String name) {
        int pos = Arrays.binarySearch(this.names, name);
        if (pos < 0) {
            throw new IllegalArgumentException("No field named '" + name + "' could be found");
        }
        return this.fields[pos];
    }

    @Override
    public void put(String name, boolean val) {
        this.find(name).setBoolean(val);
    }

    @Override
    public void put(String name, byte val) {
        this.find(name).setByte(val);
    }

    @Override
    public void put(String name, char val) {
        this.find(name).setChar(val);
    }

    @Override
    public void put(String name, short val) {
        this.find(name).setShort(val);
    }

    @Override
    public void put(String name, int val) {
        this.find(name).setInt(val);
    }

    @Override
    public void put(String name, long val) {
        this.find(name).setLong(val);
    }

    @Override
    public void put(String name, float val) {
        this.find(name).setFloat(val);
    }

    @Override
    public void put(String name, double val) {
        this.find(name).setDouble(val);
    }

    @Override
    public void put(String name, Object val) {
        this.find(name).setObject(val);
    }

    @Override
    @Deprecated
    public final void write(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("write(ObjectOutput)");
    }

    protected final void write(Marshaller marshaller) throws IOException {
        FieldPutter[] fields = this.fields;
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            try {
                fields[i].write(marshaller);
                continue;
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)this.names[i]);
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation((Throwable)e, (String)this.names[i]);
                throw e;
            }
        }
    }
}

