/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.cachemanager.RestSourceMigrator;
import org.infinispan.rest.logging.Log;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.logging.LogFactory;

public class RestCacheManager<V> {
    protected static final Log logger = (Log)LogFactory.getLog(RestCacheManager.class, Log.class);
    private final EmbeddedCacheManager instance;
    private final InternalCacheRegistry icr;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private final Map<String, AdvancedCache<Object, V>> knownCaches = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);

    public RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.icr = (InternalCacheRegistry)instance.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        this.allowInternalCacheAccess = instance.getCacheManagerConfiguration().security().authorization().enabled();
    }

    public AdvancedCache<Object, V> getCache(String name, MediaType keyContentType, MediaType valueContentType) {
        if (this.isCacheIgnored.test(name)) {
            throw logger.cacheUnavailable(name);
        }
        if (keyContentType == null || valueContentType == null) {
            throw logger.missingRequiredMediaType(name);
        }
        this.checkCacheAvailable(name);
        String cacheKey = name + keyContentType.toString() + valueContentType.getTypeSubtype();
        AdvancedCache<Object, V> registered = this.knownCaches.get(cacheKey);
        if (registered != null) {
            return registered;
        }
        AdvancedCache cache = this.instance.getCache(name).getAdvancedCache();
        this.tryRegisterMigrationManager(cache);
        AdvancedCache encodedCache = cache.getAdvancedCache().withMediaType(keyContentType.toString(), valueContentType.toString());
        this.knownCaches.putIfAbsent(cacheKey, encodedCache);
        return encodedCache;
    }

    public AdvancedCache<Object, V> getCache(String name) {
        return this.getCache(name, MediaType.MATCH_ALL, MediaType.MATCH_ALL);
    }

    private void checkCacheAvailable(String cacheName) {
        if (!"___defaultcache".equals(cacheName) && !this.instance.getCacheNames().contains(cacheName)) {
            throw logger.cacheNotFound(cacheName);
        }
        if (this.icr.isPrivateCache(cacheName)) {
            throw logger.requestNotAllowedToInternalCaches(cacheName);
        }
        if (!this.allowInternalCacheAccess && this.icr.isInternalCache(cacheName) && !this.icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.USER)) {
            throw logger.requestNotAllowedToInternalCachesWithoutAuthz(cacheName);
        }
    }

    public CacheEntry<Object, V> getInternalEntry(String cacheName, Object key, MediaType keyContentType, MediaType mediaType) {
        return this.getInternalEntry(cacheName, key, false, keyContentType, mediaType);
    }

    public void remove(String cacheName, Object key, MediaType keyContentType, boolean async) {
        AdvancedCache<Object, V> cache = this.getCache(cacheName, keyContentType, MediaType.MATCH_ALL);
        if (async) {
            cache.removeAsync(key);
        } else {
            cache.remove(key);
        }
    }

    public MediaType getValueConfiguredFormat(String cacheName) {
        return this.getCache(cacheName).getCacheConfiguration().encoding().valueDataType().mediaType();
    }

    public CacheEntry<Object, V> getInternalEntry(String cacheName, Object key, boolean skipListener, MediaType keyContentType, MediaType mediaType) {
        AdvancedCache cache = skipListener ? this.getCache(cacheName, keyContentType, mediaType).withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}) : this.getCache(cacheName, keyContentType, mediaType);
        return cache.getCacheEntry(key);
    }

    public String getNodeName() {
        Address addressToBeReturned = this.instance.getAddress();
        if (addressToBeReturned == null) {
            return "0.0.0.0";
        }
        return addressToBeReturned.toString();
    }

    public String getServerAddress() {
        Transport transport = this.instance.getTransport();
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return "0.0.0.0";
    }

    public String getPrimaryOwner(String cacheName, Object key) {
        DistributionManager dm = this.getCache(cacheName).getDistributionManager();
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).primary().toString();
    }

    public EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    private void tryRegisterMigrationManager(AdvancedCache<?, ?> cache) {
        ComponentRegistry cr = cache.getComponentRegistry();
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator(new RestSourceMigrator((Cache<String, ?>)cache));
        }
    }
}

