/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;

public enum SchemaAutoTooling {
    CREATE("create"),
    CREATE_DROP("create-drop"),
    UPDATE("update"),
    VALIDATE("validate"),
    NONE("none");

    private final String externalForm;

    private SchemaAutoTooling(String externalForm) {
        this.externalForm = externalForm;
    }

    public static SchemaAutoTooling interpret(String configurationValue) {
        if (StringHelper.isEmpty(configurationValue) || SchemaAutoTooling.NONE.externalForm.equals(configurationValue)) {
            return null;
        }
        if (SchemaAutoTooling.VALIDATE.externalForm.equals(configurationValue)) {
            return VALIDATE;
        }
        if (SchemaAutoTooling.UPDATE.externalForm.equals(configurationValue)) {
            return UPDATE;
        }
        if (SchemaAutoTooling.CREATE.externalForm.equals(configurationValue)) {
            return CREATE;
        }
        if (SchemaAutoTooling.CREATE_DROP.externalForm.equals(configurationValue)) {
            return CREATE_DROP;
        }
        throw new HibernateException("Unrecognized hbm2ddl_auto value : " + configurationValue + ".  Supported values include 'create', 'create-drop', 'update', 'none' and 'validate'.");
    }
}

