/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.IdleStateHandlerProvider;
import org.infinispan.server.core.transport.NettyInitializer;

public class TimeoutEnabledChannelInitializer<C extends ProtocolServerConfiguration>
implements NettyInitializer {
    private final ProtocolServer<C> hotRodServer;

    public TimeoutEnabledChannelInitializer(ProtocolServer<C> hotRodServer) {
        this.hotRodServer = hotRodServer;
    }

    public void initializeChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("idleHandler", (ChannelHandler)new IdleStateHandler(this.hotRodServer.getConfiguration().idleTimeout(), 0, 0));
        pipeline.addLast("idleHandlerProvider", (ChannelHandler)new IdleStateHandlerProvider());
    }
}

