/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.HeaderStateReader;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSBTypeHandler;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;

@Deprecated
public class ObjStoreBrowser
implements ObjStoreBrowserMBean {
    private static final String SUBORDINATE_AA_TYPE = "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction/SubordinateAtomicAction/JCA";
    private static final String SUBORDINATE_ATI_TYPE = "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/ServerTransaction/JCA";
    private static OSBTypeHandler[] defaultOsbTypes = new OSBTypeHandler[]{new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.recovery.arjunacore.RecoverConnectableAtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.RecoverConnectableAtomicActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicActionConnectable", null), new OSBTypeHandler(false, "com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.SubordinateActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction/SubordinateAtomicAction/JCA", null), new OSBTypeHandler(true, "com.arjuna.ats.arjuna.AtomicAction", "com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction", null)};
    private static OSBTypeHandler[] defaultJTSOsbTypes = new OSBTypeHandler[]{new OSBTypeHandler(true, false, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSXAResourceRecordWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSXAResourceRecordWrapper", "CosTransactions/XAResourceRecord", null), new OSBTypeHandler(false, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JCAServerTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/ServerTransaction/JCA", "com.hp.mwtests.ts.jta.jts.tools.JCAServerTransactionHeaderReader"), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ArjunaTransactionImpleWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple", null), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/ServerTransaction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionHeaderReader"), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteServerTransaction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionHeaderReader"), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.RecoveredTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteHeuristicTransaction", null), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteHeuristicServerTransaction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ServerTransactionHeaderReader"), new OSBTypeHandler(true, "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.RecoveredTransactionWrapper", "com.arjuna.ats.internal.jta.tools.osb.mbean.jts.JTSActionBean", "StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteTransaction", null)};
    private static Map<String, OSBTypeHandler> osbTypeMap = new HashMap<String, OSBTypeHandler>();
    public static final String OBJ_STORE_BROWSER_HANDLERS = "com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserHandlers";
    private static final String STORE_MBEAN_NAME = "jboss.jta:type=ObjectStore";
    private Map<String, List<UidWrapper>> registeredMBeans = new HashMap<String, List<UidWrapper>>();
    private boolean exposeAllLogs = false;

    public static HeaderStateReader getHeaderStateUnpacker(String type) {
        OSBTypeHandler osbType = osbTypeMap.get(type);
        return osbType != null ? osbType.getHeaderStateReader() : null;
    }

    public void start() {
        JMXServer.getAgent().registerMBean(STORE_MBEAN_NAME, this);
    }

    public void stop() {
        this.unregisterMBeans();
        JMXServer.getAgent().unregisterMBean(STORE_MBEAN_NAME);
    }

    private void unregisterMBeans(List<UidWrapper> beans) {
        for (UidWrapper w : beans) {
            w.unregister();
        }
        beans.clear();
    }

    private void unregisterMBeans() {
        for (List<UidWrapper> uids : this.registeredMBeans.values()) {
            this.unregisterMBeans(uids);
        }
        this.registeredMBeans.clear();
    }

    private void registerMBeans() {
        for (List<UidWrapper> uids : this.registeredMBeans.values()) {
            for (UidWrapper w : uids) {
                w.register();
            }
        }
    }

    @Deprecated
    public void setTypes(Map<String, String> types) {
    }

    public boolean setType(String osTypeClassName, String beanTypeClassName) {
        try {
            Class<?> cls = Class.forName(osTypeClassName);
            StateManager sm = (StateManager)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            String typeName = ObjStoreBrowser.canonicalType(sm.type());
            if (typeName == null || typeName.length() == 0) {
                return false;
            }
            osbTypeMap.put(typeName, new OSBTypeHandler(true, osTypeClassName, beanTypeClassName, typeName, null));
            typeName = typeName.replaceAll("/", File.separator);
            osbTypeMap.put(typeName, new OSBTypeHandler(true, osTypeClassName, beanTypeClassName, typeName, null));
            return true;
        }
        catch (Exception e) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)("Invalid class type in system property ObjStoreBrowserHandlers: " + osTypeClassName));
            }
            return false;
        }
    }

    public OSBTypeHandler registerHandler(OSBTypeHandler handler) {
        return osbTypeMap.put(handler.getTypeName(), handler);
    }

    private void initTypeHandlers(String handlers) {
        for (String h : handlers.split(",")) {
            String[] handler = h.split("=");
            if (handler.length != 2) continue;
            this.setType(handler[0], handler[1]);
        }
    }

    private void init(String logDir) {
        if (logDir != null) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(logDir);
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ObjectStoreDir: " + arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir()));
        }
        this.setExposeAllRecordsAsMBeans(arjPropertyManager.getObjectStoreEnvironmentBean().getExposeAllLogRecordsAsMBeans());
        for (OSBTypeHandler osbType : defaultOsbTypes) {
            osbTypeMap.put(osbType.getTypeName(), osbType);
        }
        for (OSBTypeHandler osbType : defaultJTSOsbTypes) {
            osbTypeMap.put(osbType.getTypeName(), osbType);
        }
        this.initTypeHandlers(System.getProperty(OBJ_STORE_BROWSER_HANDLERS, ""));
    }

    public ObjStoreBrowser() {
        this.init(null);
    }

    public ObjStoreBrowser(String logDir) {
        this.init(logDir);
    }

    public StringBuilder dump(StringBuilder sb) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.registeredMBeans.entrySet()) {
            sb.append(typeEntry.getKey()).append('\n');
            for (UidWrapper uid : typeEntry.getValue()) {
                uid.toString("\t", sb);
            }
        }
        return sb;
    }

    public UidWrapper findUid(Uid uid) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.registeredMBeans.entrySet()) {
            for (UidWrapper w : typeEntry.getValue()) {
                if (!w.getUid().equals(uid)) continue;
                return w;
            }
        }
        return null;
    }

    @Deprecated
    public UidWrapper findUid(String uid) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.registeredMBeans.entrySet()) {
            for (UidWrapper w : typeEntry.getValue()) {
                if (!w.getUid().stringForm().equals(uid)) continue;
                return w;
            }
        }
        return null;
    }

    private boolean isRegistered(String type, Uid uid) {
        List<UidWrapper> beans = this.registeredMBeans.get(type);
        if (beans != null) {
            for (UidWrapper w : beans) {
                if (!uid.equals(w.getUid())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void viewSubordinateAtomicActions(boolean enable) {
        OSBTypeHandler subordinateATI;
        ArrayList<String> records = new ArrayList<String>();
        OSBTypeHandler subordinateAA = osbTypeMap.get(SUBORDINATE_AA_TYPE);
        if (subordinateAA != null) {
            subordinateAA.setEnabled(enable);
            records.add(subordinateAA.getRecordClass());
        }
        if ((subordinateATI = osbTypeMap.get(SUBORDINATE_ATI_TYPE)) != null) {
            subordinateATI.setEnabled(enable);
            records.add(subordinateATI.getRecordClass());
        }
        if (!enable) {
            for (List<UidWrapper> uids : this.registeredMBeans.values()) {
                Iterator<UidWrapper> i = uids.iterator();
                while (i.hasNext()) {
                    UidWrapper w = i.next();
                    if (!records.contains(w.getClassName())) continue;
                    i.remove();
                    w.unregister();
                }
            }
        }
    }

    @Override
    public void setExposeAllRecordsAsMBeans(boolean exposeAllLogs) {
        this.exposeAllLogs = exposeAllLogs;
    }

    private void unregisterRemovedUids(Map<String, Collection<Uid>> allCurrUids) {
        for (Map.Entry<String, List<UidWrapper>> e : this.registeredMBeans.entrySet()) {
            String type = e.getKey();
            List<UidWrapper> registeredBeansOfType = e.getValue();
            Collection<Uid> currUidsOfType = allCurrUids.get(type);
            if (currUidsOfType != null) {
                Iterator<UidWrapper> iterator = registeredBeansOfType.iterator();
                while (iterator.hasNext()) {
                    UidWrapper w = iterator.next();
                    if (currUidsOfType.contains(w.getUid())) continue;
                    w.unregister();
                    iterator.remove();
                }
                continue;
            }
            this.unregisterMBeans(registeredBeansOfType);
        }
    }

    @Override
    public synchronized void probe() throws MBeanException {
        HashMap<String, Collection<Uid>> currUidsForType = new HashMap<String, Collection<Uid>>();
        for (String string : this.getTypes()) {
            currUidsForType.put(string, this.getUids(string));
        }
        this.unregisterRemovedUids(currUidsForType);
        for (Map.Entry entry : currUidsForType.entrySet()) {
            String type = (String)entry.getKey();
            List<UidWrapper> beans = this.registeredMBeans.get(type);
            if (beans == null) {
                beans = new ArrayList<UidWrapper>();
                this.registeredMBeans.put(type, beans);
            }
            for (Uid uid : (Collection)entry.getValue()) {
                UidWrapper w;
                if (this.isRegistered(type, uid) || (w = this.createBean(uid, type)) == null) continue;
                beans.add(w);
            }
        }
        this.registerMBeans();
    }

    public List<UidWrapper> probe(String type) {
        return (type = ObjStoreBrowser.canonicalType(type)) == null ? null : this.registeredMBeans.get(type);
    }

    private UidWrapper createBean(Uid uid, String type) {
        boolean registerBean;
        OSBTypeHandler osbType = osbTypeMap.get(type);
        boolean bl = registerBean = osbType != null && osbType.isAllowRegistration();
        if (osbType == null && !this.exposeAllLogs) {
            return null;
        }
        if (this.exposeAllLogs) {
            registerBean = true;
        }
        String beanType = osbType == null ? OSEntryBean.class.getName() : osbType.getBeanClass();
        String stateType = osbType == null ? null : osbType.getRecordClass();
        UidWrapper w = new UidWrapper(this, beanType, type, stateType, uid, registerBean);
        w.createMBean();
        return w;
    }

    private Collection<Uid> getUids(String type) throws MBeanException {
        ArrayList<Uid> uids = new ArrayList<Uid>();
        try {
            Uid u;
            ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), type);
            while ((u = iter.iterate()) != null && !Uid.nullUid().equals(u)) {
                uids.add(u);
            }
        }
        catch (ObjectStoreException | IOException e) {
            throw new MBeanException(e);
        }
        return uids;
    }

    public static String canonicalType(String type) {
        if (type == null) {
            return null;
        }
        type = type.replace(File.separator, "/");
        while (type.startsWith("/")) {
            type = type.substring(1);
        }
        return type;
    }

    private Collection<String> getTypes() {
        ArrayList<String> allTypes;
        block5: {
            allTypes = new ArrayList<String>();
            InputObjectState types = new InputObjectState();
            try {
                if (!StoreManager.getRecoveryStore().allTypes(types)) break block5;
                try {
                    String typeName;
                    while ((typeName = ObjStoreBrowser.canonicalType(types.unpackString())).length() != 0) {
                        allTypes.add(typeName);
                    }
                }
                catch (IOException e1) {
                }
            }
            catch (ObjectStoreException e) {
                if (!tsLogger.logger.isTraceEnabled()) break block5;
                tsLogger.logger.trace((Object)e.toString());
            }
        }
        return allTypes;
    }
}

