/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.Predicates;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.util.ComparableArrayComparator;

public final class FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements FilterSubscription {
    private final String queryString;
    private final Map<String, Object> namedParameters;
    private final boolean useIntervals;
    public int index = -1;
    private final MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter;
    private final BETree beTree;
    private final List<Predicates.Subscription<AttributeId>> predicateSubscriptions = new ArrayList<Predicates.Subscription<AttributeId>>();
    private final FilterCallback callback;
    private final boolean isDeltaFilter;
    private final String[] projection;
    private final Class<?>[] projectionTypes;
    private final List<List<AttributeId>> translatedProjection;
    private final SortField[] sortFields;
    private final List<List<AttributeId>> translatedSortProjection;
    private final Object[] eventTypes;
    private Comparator<Comparable[]> comparator;

    protected FilterSubscriptionImpl(String queryString, Map<String, Object> namedParameters, boolean useIntervals, MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter, BETree beTree, FilterCallback callback, boolean isDeltaFilter, String[] projection, Class<?>[] projectionTypes, List<List<AttributeId>> translatedProjection, SortField[] sortFields, List<List<AttributeId>> translatedSortProjection, Object[] eventTypes) {
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.useIntervals = useIntervals;
        this.metadataAdapter = metadataAdapter;
        this.beTree = beTree;
        this.callback = callback;
        this.isDeltaFilter = isDeltaFilter;
        this.projection = projection;
        this.projectionTypes = projectionTypes;
        this.sortFields = sortFields;
        this.translatedProjection = translatedProjection;
        this.translatedSortProjection = translatedSortProjection;
        this.eventTypes = eventTypes;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public boolean useIntervals() {
        return this.useIntervals;
    }

    public BETree getBETree() {
        return this.beTree;
    }

    @Override
    public String getEntityTypeName() {
        return this.metadataAdapter.getTypeName();
    }

    public MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> getMetadataAdapter() {
        return this.metadataAdapter;
    }

    @Override
    public FilterCallback getCallback() {
        return this.callback;
    }

    @Override
    public boolean isDeltaFilter() {
        return this.isDeltaFilter;
    }

    @Override
    public String[] getProjection() {
        return this.projection;
    }

    public Class<?>[] getProjectionTypes() {
        return this.projectionTypes;
    }

    @Override
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Override
    public Comparator<Comparable[]> getComparator() {
        if (this.sortFields != null && this.comparator == null) {
            boolean[] direction = new boolean[this.sortFields.length];
            for (int i = 0; i < this.sortFields.length; ++i) {
                direction[i] = this.sortFields[i].isAscending();
            }
            this.comparator = new ComparableArrayComparator(direction);
        }
        return this.comparator;
    }

    @Override
    public Object[] getEventTypes() {
        return this.eventTypes;
    }

    public void registerProjection(PredicateIndex<AttributeMetadata, AttributeId> predicateIndex) {
        int i = 0;
        if (this.translatedProjection != null) {
            i = predicateIndex.addProjections(this, this.translatedProjection, i);
        }
        if (this.translatedSortProjection != null) {
            predicateIndex.addProjections(this, this.translatedSortProjection, i);
        }
    }

    public void unregisterProjection(PredicateIndex<AttributeMetadata, AttributeId> predicateIndex) {
        if (this.translatedProjection != null) {
            predicateIndex.removeProjections(this, this.translatedProjection);
        }
        if (this.translatedSortProjection != null) {
            predicateIndex.removeProjections(this, this.translatedSortProjection);
        }
    }

    public void subscribe(PredicateIndex<AttributeMetadata, AttributeId> predicateIndex) {
        for (BENode node : this.beTree.getNodes()) {
            if (!(node instanceof PredicateNode)) continue;
            PredicateNode predicateNode = (PredicateNode)node;
            this.predicateSubscriptions.add(predicateIndex.addSubscriptionForPredicate(predicateNode, this));
        }
    }

    public void unsubscribe(PredicateIndex<AttributeMetadata, AttributeId> predicateIndex) {
        for (Predicates.Subscription<AttributeId> subscription : this.predicateSubscriptions) {
            predicateIndex.removeSubscriptionForPredicate(subscription);
        }
    }
}

