/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.ql.parse;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

abstract class ParserBase
extends Parser {
    private final Deque<Boolean> enableParameterUsage = new ArrayDeque<Boolean>();
    private final List<String> errorMessages = new LinkedList<String>();
    private int unaliasedCount = 0;

    protected ParserBase(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    protected final String buildUniqueImplicitAlias() {
        return "<gen:" + this.unaliasedCount++ + ">";
    }

    protected final boolean isParameterUsageEnabled() {
        return !this.enableParameterUsage.isEmpty() && this.enableParameterUsage.peek() != false;
    }

    protected final void pushEnableParameterUsage(boolean enable) {
        this.enableParameterUsage.push(enable);
    }

    protected final void popEnableParameterUsage() {
        this.enableParameterUsage.pop();
    }

    protected final boolean validateSoftKeyword(String text) {
        return this.validateSoftKeyword(1, text);
    }

    protected final boolean validateSoftKeyword(int offset, String text) {
        if (this.input == null) {
            return false;
        }
        Token token = this.input.LT(offset);
        return token != null && text.equalsIgnoreCase(token.getText());
    }

    public final boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public final List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public final void reportError(RecognitionException e) {
        this.errorMessages.add(this.generateError(ParserBase.getRuleInvocationStack((Throwable)e, (String)((Object)((Object)this)).getClass().getName()), this.getTokenNames(), e));
        super.reportError(e);
    }

    private String generateError(List invocationStack, String[] tokenNames, RecognitionException e) {
        String localization = invocationStack + ": line " + e.line + ":" + e.charPositionInLine + " ";
        return this.generateError(localization, tokenNames, e);
    }

    private String generateError(String localization, String[] tokenNames, RecognitionException e) {
        String message = "";
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String tokenName = "<unknown>";
            if (mte.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mte.expecting];
            }
            message = localization + "mismatched token: " + e.token + "; expecting type " + tokenName;
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            String tokenName = "<unknown>";
            if (mtne.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mtne.expecting];
            }
            message = localization + "mismatched tree node: " + mtne.node + "; expecting type " + tokenName;
        } else if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            message = localization + "state " + nvae.stateNumber + " (decision=" + nvae.decisionNumber + ") no viable alt; token=" + e.token;
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            message = localization + "required (...)+ loop (decision=" + eee.decisionNumber + ") did not match anything; token=" + e.token;
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            message = localization + "mismatched token: " + e.token + "; expecting set " + mse.expecting;
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            message = localization + "mismatched token: " + e.token + "; expecting set " + mse.expecting;
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            message = localization + "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
        return message;
    }
}

