/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.util.function.Function;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;

abstract class RealmReadinessHandler
implements HttpHandler {
    private final Function<HttpServerExchange, Boolean> readyFunction;
    private final HttpHandler next;

    RealmReadinessHandler(Function<HttpServerExchange, Boolean> readyFunction, HttpHandler next) {
        this.readyFunction = readyFunction;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.readyFunction.apply(exchange).booleanValue()) {
            this.next.handleRequest(exchange);
        } else {
            try {
                this.rejectRequest(exchange);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.error(e);
                exchange.setStatusCode(500);
                exchange.endExchange();
            }
        }
    }

    abstract void rejectRequest(HttpServerExchange var1) throws Exception;
}

