/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;

class SerialChangesetsElasticsearchWorkOrchestrator
implements FlushableElasticsearchWorkOrchestrator {
    private final BulkAndSequenceAggregator aggregator;
    private CompletableFuture<Void> future = CompletableFuture.completedFuture(null);

    public SerialChangesetsElasticsearchWorkOrchestrator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.aggregator = new BulkAndSequenceAggregator(sequenceBuilder, bulker);
    }

    @Override
    public CompletableFuture<Void> submit(Iterable<ElasticsearchWork<?>> nonBulkedWorks) {
        this.aggregator.init(this.future);
        for (ElasticsearchWork<?> work : nonBulkedWorks) {
            work.aggregate(this.aggregator);
        }
        CompletableFuture<Void> sequenceFuture = this.aggregator.flushSequence();
        this.future = sequenceFuture;
        return sequenceFuture;
    }

    @Override
    public CompletableFuture<Void> flush() {
        this.aggregator.flushBulk();
        return this.future;
    }

    @Override
    public void reset() {
        this.aggregator.reset();
    }

    private static class BulkAndSequenceAggregator
    implements ElasticsearchWorkAggregator {
        private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
        private final ElasticsearchWorkBulker bulker;

        public BulkAndSequenceAggregator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
            this.sequenceBuilder = sequenceBuilder;
            this.bulker = bulker;
        }

        public void init(CompletableFuture<?> previous) {
            this.sequenceBuilder.init(previous);
        }

        @Override
        public void addBulkable(BulkableElasticsearchWork<?> work) {
            this.bulker.add(work);
        }

        @Override
        public void addNonBulkable(ElasticsearchWork<?> work) {
            if (this.bulker.flushBulked()) {
                this.bulker.flushBulk();
            }
            this.sequenceBuilder.addNonBulkExecution(work);
        }

        public CompletableFuture<Void> flushSequence() {
            this.bulker.flushBulked();
            return this.sequenceBuilder.build();
        }

        public void flushBulk() {
            this.bulker.flushBulk();
        }

        public void reset() {
            this.bulker.reset();
        }
    }
}

