/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.FlowableSubscriber;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class MaybeDelayOtherPublisher<T, U>
extends AbstractMaybeWithUpstream<T, T> {
    final Publisher<U> other;

    public MaybeDelayOtherPublisher(MaybeSource<T> source, Publisher<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new DelayMaybeObserver<T, U>(observer, this.other));
    }

    static final class OtherSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = -1215060610805418006L;
        final MaybeObserver<? super T> actual;
        T value;
        Throwable error;

        OtherSubscriber(MaybeObserver<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            Subscription s = (Subscription)this.get();
            if (s != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                s.cancel();
                this.onComplete();
            }
        }

        public void onError(Throwable t) {
            Throwable e = this.error;
            if (e == null) {
                this.actual.onError(t);
            } else {
                this.actual.onError(new CompositeException(e, t));
            }
        }

        public void onComplete() {
            Throwable e = this.error;
            if (e != null) {
                this.actual.onError(e);
            } else {
                T v = this.value;
                if (v != null) {
                    this.actual.onSuccess(v);
                } else {
                    this.actual.onComplete();
                }
            }
        }
    }

    static final class DelayMaybeObserver<T, U>
    implements MaybeObserver<T>,
    Disposable {
        final OtherSubscriber<T> other;
        final Publisher<U> otherSource;
        Disposable d;

        DelayMaybeObserver(MaybeObserver<? super T> actual, Publisher<U> otherSource) {
            this.other = new OtherSubscriber<T>(actual);
            this.otherSource = otherSource;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
            SubscriptionHelper.cancel(this.other);
        }

        @Override
        public boolean isDisposed() {
            return SubscriptionHelper.isCancelled((Subscription)this.other.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.other.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            this.other.value = value;
            this.subscribeNext();
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.other.error = e;
            this.subscribeNext();
        }

        @Override
        public void onComplete() {
            this.d = DisposableHelper.DISPOSED;
            this.subscribeNext();
        }

        void subscribeNext() {
            this.otherSource.subscribe(this.other);
        }
    }
}

