/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractModuleTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class ModuleUpdateTask
extends AbstractModuleTask {
    ModuleUpdateTask(PatchingTaskDescription description) {
        super(description);
    }

    @Override
    public boolean prepare(PatchingTaskContext context) throws IOException {
        this.backupHash = this.backup(context);
        byte[] contentHash = ((ModuleItem)this.contentItem).getContentHash();
        if (Arrays.equals(this.backupHash, contentHash)) {
            return true;
        }
        byte[] expected = this.description.getModification().getTargetHash();
        if (Arrays.equals(this.backupHash, expected)) {
            return !this.description.hasConflicts();
        }
        return false;
    }

    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        File targetDir = context.getTargetFile(this.contentItem);
        File sourceDir = loader.getFile(this.contentItem);
        if (sourceDir.exists()) {
            IoUtils.copyFile(sourceDir, targetDir);
        } else {
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(targetDir.getAbsolutePath());
            }
            Path moduleXml = targetDir.toPath().resolve("module.xml");
            ByteArrayInputStream is = new ByteArrayInputStream(PatchUtils.getAbsentModuleContent((ModuleItem)this.contentItem));
            Files.copy(is, moduleXml, StandardCopyOption.REPLACE_EXISTING);
        }
        return HashUtils.hashFile(targetDir);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        ModuleItem item = ModuleUpdateTask.createContentItem((ModuleItem)this.contentItem, itemHash);
        ModificationType type = original.getType() != ModificationType.MODIFY && itemHash.length == 0 ? ModificationType.REMOVE : ModificationType.MODIFY;
        return new ContentModification(item, targetHash, type, original.getCondition());
    }
}

